/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import net.jaams.jaamseverwinter.ModStructures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraftforge.common.util.Lazy;

public class IceFortressPiece
extends StructurePiece {
    public static final Lazy<StructurePieceType> TYPE = Lazy.of(() -> (StructurePieceType)ModStructures.ICE_FORTRESS_PIECE_TYPE.get());
    private static final int WIDTH = 17;
    private static final int LENGTH = 17;
    private static final int WALL_HEIGHT = 6;
    private static final int TOWER_HEIGHT = 10;
    private final BlockPos basePos;

    public IceFortressPiece(BlockPos basePos) {
        super((StructurePieceType)TYPE.get(), 0, new BoundingBox(basePos).m_191961_(8));
        this.basePos = basePos;
    }

    public IceFortressPiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super((StructurePieceType)TYPE.get(), tag);
        this.basePos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("x", this.basePos.m_123341_());
        tag.m_128405_("y", this.basePos.m_123342_());
        tag.m_128405_("z", this.basePos.m_123343_());
    }

    public void m_213694_(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        this.generateFloor(level, box, random);
        this.generateWalls(level, box, random);
        this.generateTowers(level, box, random);
        this.generateEntrance(level, box, random);
        this.generateInterior(level, box, random);
    }

    private void generateFloor(WorldGenLevel level, BoundingBox box, RandomSource random) {
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                BlockPos floorPos;
                if (Math.abs(x) + Math.abs(z) > 9 || !box.m_71051_((Vec3i)(floorPos = this.basePos.m_7918_(x, 0, z)))) continue;
                BlockState floorBlock = Math.abs(x) + Math.abs(z) > 7 || random.m_188501_() < 0.2f ? Blocks.f_50568_.m_49966_() : Blocks.f_50354_.m_49966_();
                level.m_7731_(floorPos, floorBlock, 2);
            }
        }
    }

    private void generateWalls(WorldGenLevel level, BoundingBox box, RandomSource random) {
        for (int x = -8; x <= 8; ++x) {
            for (int z = -8; z <= 8; ++z) {
                if (Math.abs(x) + Math.abs(z) != 9) continue;
                BlockPos wallBase = this.basePos.m_7918_(x, 0, z);
                for (int y = 1; y <= 6; ++y) {
                    BlockState wallBlock;
                    BlockPos wallPos = wallBase.m_7918_(0, y, 0);
                    if (!box.m_71051_((Vec3i)wallPos)) continue;
                    BlockState blockState = wallBlock = y == 6 && random.m_188499_() ? Blocks.f_50568_.m_49966_() : Blocks.f_50126_.m_49966_();
                    if (x == 0 && z == -8 && y <= 3) {
                        wallBlock = Blocks.f_50016_.m_49966_();
                    }
                    level.m_7731_(wallPos, wallBlock, 2);
                }
            }
        }
    }

    private void generateTowers(WorldGenLevel level, BoundingBox box, RandomSource random) {
        int[] towerOffsets;
        for (int xOffset : towerOffsets = new int[]{-6, 6}) {
            for (int zOffset : towerOffsets) {
                BlockPos towerBase = this.basePos.m_7918_(xOffset, 0, zOffset);
                int towerHeight = 10 + random.m_188503_(3) - 1;
                for (int y = 1; y <= towerHeight; ++y) {
                    for (int x = -2; x <= 2; ++x) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos towerPos;
                            if (x * x + z * z > 4 || !box.m_71051_((Vec3i)(towerPos = towerBase.m_7918_(x, y, z)))) continue;
                            if (x == 0 && z == 0 && y < towerHeight - 2) {
                                level.m_7731_(towerPos, Blocks.f_50016_.m_49966_(), 2);
                                continue;
                            }
                            level.m_7731_(towerPos, Blocks.f_50568_.m_49966_(), 2);
                        }
                    }
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos topPos;
                        if (x * x + z * z > 4 || Math.abs(x) == 2 && Math.abs(z) == 2 || !box.m_71051_((Vec3i)(topPos = towerBase.m_7918_(x, towerHeight, z))) || !random.m_188499_()) continue;
                        level.m_7731_(topPos, Blocks.f_50354_.m_49966_(), 2);
                    }
                }
            }
        }
    }

    private void generateEntrance(WorldGenLevel level, BoundingBox box, RandomSource random) {
        BlockPos adjustedBase = this.basePos.m_7918_(0, 0, -8);
        for (int y = 1; y <= 5; ++y) {
            for (int x = -3; x <= 3; ++x) {
                BlockPos archPos;
                if (y == 5 && Math.abs(x) > 1 || !box.m_71051_((Vec3i)(archPos = adjustedBase.m_7918_(x, y, 0)))) continue;
                BlockState block = y == 5 || Math.abs(x) == 3 ? Blocks.f_50568_.m_49966_() : Blocks.f_50016_.m_49966_();
                level.m_7731_(archPos, block, 2);
            }
        }
    }

    private void generateInterior(WorldGenLevel level, BoundingBox box, RandomSource random) {
        BlockPos adjustedBase = this.basePos;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos platformPos = adjustedBase.m_7918_(x, 1, z);
                if (!box.m_71051_((Vec3i)platformPos)) continue;
                level.m_7731_(platformPos, Blocks.f_50354_.m_49966_(), 2);
            }
        }
    }
}

