/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import net.jaams.jaamseverwinter.entity.IceriteRockProjectileEntity;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MeteorShowerEvent {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));
    private static final int TICKS_PER_5_MINUTES = 6000;
    private static final int SHOWER_DURATION = 300;
    private static final int METEOR_SPAWN_RATE = 10;
    private static final Map<ServerLevel, MeteorShowerData> showerData = new HashMap<ServerLevel, MeteorShowerData>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel level = server.m_129880_(EVERWINTER_DIMENSION);
        if (level == null) {
            return;
        }
        MeteorShowerData data = showerData.computeIfAbsent(level, k -> new MeteorShowerData());
        long currentTick = server.m_129921_();
        if (!data.isActive && currentTick - data.startTick >= 6000L && MeteorShowerEvent.anyPlayerCanSeeSky(level)) {
            MeteorShowerEvent.startMeteorShower(level, currentTick);
        }
        if (data.isActive) {
            if (currentTick - data.startTick >= 300L) {
                data.isActive = false;
                data.startTick = currentTick;
            } else if ((currentTick - data.startTick) % 10L == 0L) {
                MeteorShowerEvent.spawnMeteorShower(level);
            }
        }
    }

    public static void startMeteorShower(ServerLevel level, long currentTick) {
        MeteorShowerData data = showerData.computeIfAbsent(level, k -> new MeteorShowerData());
        data.isActive = true;
        data.startTick = currentTick;
        level.m_6907_().forEach(player -> {
            if (!player.m_9236_().m_5776_() && level.m_45527_(player.m_20183_())) {
                player.m_5661_((Component)Component.m_237113_((String)"A meteor shower begins in the Everwinter sky!").m_130940_(ChatFormatting.BLUE), true);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            }
        });
    }

    private static void spawnMeteorShower(ServerLevel level) {
        RandomSource random = level.m_213780_();
        int meteorLimit = 5;
        int spawned = 0;
        for (ServerPlayer player : level.m_6907_()) {
            if (spawned >= meteorLimit) break;
            if (!level.m_45527_(player.m_20183_())) continue;
            double centerX = player.m_20185_();
            double centerZ = player.m_20189_();
            double spawnX = centerX + (random.m_188500_() - 0.5) * 10.0;
            double spawnZ = centerZ + (random.m_188500_() - 0.5) * 10.0;
            double spawnY = player.m_20186_() + 20.0;
            IceriteRockProjectileEntity meteor = new IceriteRockProjectileEntity((EntityType<? extends IceriteRockProjectileEntity>)((EntityType)JaamsEverwinterModEntities.ICERITE_ROCK_PROJECTILE.get()), spawnX, spawnY, spawnZ, (Level)level);
            meteor.getPersistentData().m_128379_("isMeteor", true);
            meteor.m_20334_((random.m_188500_() - 0.5) * 0.1, -0.5, (random.m_188500_() - 0.5) * 0.1);
            level.m_7967_((Entity)meteor);
            ++spawned;
        }
    }

    private static boolean anyPlayerCanSeeSky(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            if (!level.m_45527_(player.m_20183_())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"startmeteor").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (!level.m_46472_().equals(EVERWINTER_DIMENSION)) {
                source.m_81352_((Component)Component.m_237113_((String)"This command only works in the Everwinter dimension."));
                return 0;
            }
            if (!MeteorShowerEvent.anyPlayerCanSeeSky(level)) {
                source.m_81352_((Component)Component.m_237113_((String)"No players can see the sky in Everwinter."));
                return 0;
            }
            MeteorShowerEvent.startMeteorShower(level, level.m_7654_().m_129921_());
            source.m_288197_(() -> Component.m_237113_((String)"Meteor shower started!"), true);
            return 1;
        }));
    }

    private static class MeteorShowerData {
        public long startTick = 0L;
        public boolean isActive = false;
    }
}

