/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import java.util.HashMap;
import java.util.Map;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModEntities;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MockerSpawnEvent {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));
    private static final int MIN_TICKS = 400;
    private static final int MAX_TICKS = 600;
    private static final float SPAWN_CHANCE = 0.5f;
    private static final int SPAWN_DISTANCE = 3;
    private static final int MAX_SEARCH_RADIUS = 5;
    private static final Map<ServerLevel, MockerSpawnData> spawnData = new HashMap<ServerLevel, MockerSpawnData>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel level = server.m_129880_(EVERWINTER_DIMENSION);
        if (level == null) {
            return;
        }
        MockerSpawnData data = spawnData.computeIfAbsent(level, k -> new MockerSpawnData());
        long currentTick = server.m_129921_();
        if (currentTick - data.lastSpawnTick >= (long)(400 + level.m_213780_().m_188503_(200))) {
            MockerSpawnEvent.spawnMockerBehindPlayers(level);
            data.lastSpawnTick = currentTick;
        }
    }

    private static void spawnMockerBehindPlayers(ServerLevel level) {
        RandomSource random = level.m_213780_();
        for (ServerPlayer player : level.m_6907_()) {
            Entity mocker;
            BlockPos spawnBlockPos;
            if (!(random.m_188501_() < 0.5f)) continue;
            Vec3 lookVec = player.m_20154_().m_82541_();
            Vec3 spawnPos = player.m_20182_().m_82546_(lookVec.m_82490_(3.0)).m_82520_(0.0, 1.0, 0.0);
            Vec3 safeSpawnPos = MockerSpawnEvent.findSafeSpawnPosition(level, spawnPos, player);
            if (safeSpawnPos == null || !level.m_46749_(spawnBlockPos = BlockPos.m_274446_((Position)safeSpawnPos)) || (mocker = ((EntityType)JaamsEverwinterModEntities.MOCKER.get()).m_20615_((Level)level)) == null) continue;
            mocker.m_6034_(safeSpawnPos.f_82479_, safeSpawnPos.f_82480_, safeSpawnPos.f_82481_);
            level.m_7967_(mocker);
            SoundEvent soundToPlay = random.m_188499_() ? (SoundEvent)JaamsEverwinterModSounds.CRYING_AMBIENT_1.get() : (SoundEvent)JaamsEverwinterModSounds.CRYING_AMBIENT_2.get();
            level.m_6263_(null, safeSpawnPos.f_82479_, safeSpawnPos.f_82480_, safeSpawnPos.f_82481_, soundToPlay, SoundSource.HOSTILE, 1.0f, random.m_188501_() * 0.2f + 0.9f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_175821_, safeSpawnPos.f_82479_, safeSpawnPos.f_82480_, safeSpawnPos.f_82481_, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private static Vec3 findSafeSpawnPosition(ServerLevel level, Vec3 initialPos, ServerPlayer player) {
        RandomSource random = level.m_213780_();
        BlockPos initialBlockPos = BlockPos.m_274446_((Position)initialPos);
        if (MockerSpawnEvent.isSafePosition(level, initialBlockPos)) {
            return initialPos;
        }
        for (int i = 0; i < 10; ++i) {
            int offsetX = random.m_188503_(11) - 5;
            int offsetZ = random.m_188503_(11) - 5;
            BlockPos testPos = initialBlockPos.m_7918_(offsetX, 0, offsetZ);
            if ((testPos = MockerSpawnEvent.adjustToGround(level, testPos)) == null || !MockerSpawnEvent.isSafePosition(level, testPos)) continue;
            return new Vec3((double)testPos.m_123341_() + 0.5, (double)testPos.m_123342_(), (double)testPos.m_123343_() + 0.5);
        }
        return null;
    }

    private static boolean isSafePosition(ServerLevel level, BlockPos pos) {
        BlockPos feetPos = pos;
        BlockPos headPos = pos.m_7494_();
        BlockPos belowPos = pos.m_7495_();
        return level.m_8055_(belowPos).m_280296_() && !level.m_8055_(feetPos).m_280296_() && !level.m_8055_(headPos).m_280296_();
    }

    private static BlockPos adjustToGround(ServerLevel level, BlockPos pos) {
        BlockPos testPos;
        int y;
        for (y = pos.m_123342_(); y > level.m_141937_(); --y) {
            testPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!MockerSpawnEvent.isSafePosition(level, testPos)) continue;
            return testPos;
        }
        for (y = pos.m_123342_(); y < level.m_151558_() - 1; ++y) {
            testPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            if (!MockerSpawnEvent.isSafePosition(level, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private static class MockerSpawnData {
        public long lastSpawnTick = 0L;
    }
}

