/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter", value={Dist.CLIENT})
public class ParticleSpawner {
    private static final int MAX_PARTICLE_DENSITY = 20;
    private static final float WIND_FACTOR = 0.02f;
    private static final float SNOW_SPAWN_RADIUS = 30.0f;
    private static final float BREATH_CHANCE = 0.03f;
    private static final int BREATH_COOLDOWN = 80;
    private static long lastBreathTick = -80L;
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft:dimension")), (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || !mc.f_91073_.m_46472_().equals(EVERWINTER_DIMENSION)) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        RandomSource random = level.f_46441_;
        ParticleSpawner.simulateSnowWeather(level, player, random);
        ParticleSpawner.simulateFrozenBreath(level, player, random);
    }

    private static void simulateSnowWeather(ClientLevel level, LocalPlayer player, RandomSource random) {
        int particleCount = Math.min(20, ((ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()).m_35965_() + 1);
        float windX = 0.02f * Mth.m_14031_((float)((float)level.m_46467_() * 0.01f));
        float windZ = 0.02f * Mth.m_14089_((float)((float)level.m_46467_() * 0.01f));
        for (int i = 0; i < particleCount; ++i) {
            if (!(random.m_188501_() < 0.8f)) continue;
            double x = player.m_20185_() + (random.m_188500_() - 0.5) * 30.0;
            double y = player.m_20186_() + 15.0 + random.m_188500_() * 5.0;
            double z = player.m_20189_() + (random.m_188500_() - 0.5) * 30.0;
            double xSpeed = (double)windX + (random.m_188500_() - 0.5) * 0.03;
            double ySpeed = -0.05 - random.m_188500_() * 0.02;
            double zSpeed = (double)windZ + (random.m_188500_() - 0.5) * 0.03;
            SimpleParticleType particle = random.m_188503_(3) == 0 ? ParticleTypes.f_123790_ : ParticleTypes.f_175821_;
            level.m_7106_((ParticleOptions)particle, x, y, z, xSpeed, ySpeed, zSpeed);
            if (!(random.m_188501_() < 0.5f)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y - 10.0, z, xSpeed * 0.5, ySpeed * 0.5 + 0.02, zSpeed * 0.5);
        }
    }

    private static void simulateFrozenBreath(ClientLevel level, LocalPlayer player, RandomSource random) {
        long currentTick = level.m_46467_();
        if (currentTick - lastBreathTick < 80L) {
            return;
        }
        float breathChance = 0.03f;
        if (player.m_20142_()) {
            breathChance *= 2.0f;
        }
        if (random.m_188501_() < breathChance) {
            double x = player.m_20185_();
            double y = player.m_20188_() - 0.1;
            double z = player.m_20189_();
            float yaw = player.m_146908_() * ((float)Math.PI / 180);
            float pitch = player.m_146909_() * ((float)Math.PI / 180);
            double offsetX = (double)(-Mth.m_14031_((float)yaw) * Mth.m_14089_((float)pitch)) * 0.5;
            double offsetZ = (double)(Mth.m_14089_((float)yaw) * Mth.m_14089_((float)pitch)) * 0.5;
            double offsetY = (double)(-Mth.m_14031_((float)pitch)) * 0.5;
            double xSpeed = offsetX * 0.1 + (random.m_188500_() - 0.5) * 0.02;
            double ySpeed = offsetY * 0.1 + (random.m_188500_() - 0.5) * 0.02;
            double zSpeed = offsetZ * 0.1 + (random.m_188500_() - 0.5) * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, x + offsetX, y + offsetY, z + offsetZ, xSpeed, ySpeed, zSpeed);
            lastBreathTick = currentTick;
        }
    }
}

