/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_everwinter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RespawnHandler {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ResourceKey toDimension = event.getTo();
        ServerLevel everwinterLevel = player2.m_20194_().m_129880_(EVERWINTER_DIMENSION);
        if (everwinterLevel != null && toDimension.equals(EVERWINTER_DIMENSION)) {
            int z;
            int spawnRadius = 50;
            int x = player2.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius;
            BlockPos safePos = RespawnHandler.findSafeSpawnPosition(everwinterLevel, x, z = player2.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius);
            if (safePos != null) {
                player2.m_9158_(EVERWINTER_DIMENSION, safePos, player2.m_146908_(), true, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        block6: {
            block5: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block5;
                player = (ServerPlayer)player2;
                if (!event.isEndConquered()) break block6;
            }
            return;
        }
        ServerLevel playerLevel = player.m_284548_();
        ServerLevel everwinterLevel = player.m_20194_().m_129880_(EVERWINTER_DIMENSION);
        if (everwinterLevel != null && playerLevel.m_46472_().equals(EVERWINTER_DIMENSION)) {
            int z;
            int spawnRadius = 50;
            int x = player.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius;
            BlockPos safePos = RespawnHandler.findSafeSpawnPosition(everwinterLevel, x, z = player.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius);
            if (safePos != null) {
                player.m_9158_(EVERWINTER_DIMENSION, safePos, player.m_146908_(), true, false);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ServerLevel everwinterLevel;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ServerLevel level = (ServerLevel)player.m_9236_();
        DamageSource source = event.getSource();
        BlockPos deathPos = player.m_20183_();
        Biome biome = (Biome)level.m_204166_(deathPos).m_203334_();
        boolean isColdBiome = biome.m_47554_() <= 0.0f;
        boolean isSurroundedBySnow = RespawnHandler.isSurroundedBySnowBlocks(level, deathPos);
        boolean isFreezeDamage = source.m_276093_(DamageTypes.f_268444_);
        if ((isColdBiome || isSurroundedBySnow || isFreezeDamage) && (everwinterLevel = player.m_20194_().m_129880_(EVERWINTER_DIMENSION)) != null) {
            int z;
            int spawnRadius = 50;
            int x = player.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius;
            BlockPos safePos = RespawnHandler.findSafeSpawnPosition(everwinterLevel, x, z = player.m_217043_().m_188503_(spawnRadius * 2) - spawnRadius);
            if (safePos != null) {
                player.m_9158_(EVERWINTER_DIMENSION, safePos, player.m_146908_(), true, false);
            }
        }
    }

    private static boolean isSurroundedBySnowBlocks(ServerLevel level, BlockPos pos) {
        int snowBlockCount = 0;
        int checks = 0;
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos checkPos = pos.m_7918_(dx, dy, dz);
                    if (level.m_8055_(checkPos).m_60713_(Blocks.f_50127_)) {
                        ++snowBlockCount;
                    }
                    ++checks;
                }
            }
        }
        return (float)snowBlockCount / (float)checks >= 0.5f;
    }

    private static BlockPos findSafeSpawnPosition(ServerLevel level, int x, int z) {
        int maxHeight = level.m_151558_() - 2;
        int minHeight = level.m_141937_();
        for (int y = maxHeight; y > minHeight; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            BlockPos belowPos = pos.m_7495_();
            if (!RespawnHandler.isSolidBlock(level, belowPos) || !RespawnHandler.isAirBlock(level, pos) || !RespawnHandler.isAirBlock(level, pos.m_7494_())) continue;
            return pos;
        }
        return new BlockPos(x, 64, z);
    }

    private static boolean isSolidBlock(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_280296_();
    }

    private static boolean isAirBlock(ServerLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(Blocks.f_50016_) || !level.m_8055_(pos).m_280296_();
    }
}

