/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.jaams.jaamseverwinter.EverwinterSkyRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class Setup {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft:dimension")), (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));
    public static final Predicate<Object[]> EVERWINTER_SKY_RENDERER = params -> {
        ClientLevel level;
        int ticks = (Integer)params[1];
        float partialTick = ((Float)params[2]).floatValue();
        PoseStack poseStack = (PoseStack)params[3];
        Matrix4f projectionMatrix = (Matrix4f)params[5];
        Runnable setupFog = (Runnable)params[7];
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (entity != null && (level = minecraft.f_91073_).m_46472_().equals(EVERWINTER_DIMENSION)) {
            RenderSystem.defaultBlendFunc();
            EverwinterSkyRenderer.renderDeepSky(poseStack, projectionMatrix, -16777216, -16116696);
            EverwinterSkyRenderer.renderAbyss(poseStack, projectionMatrix, -16119286, true);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            EverwinterSkyRenderer.renderStars(poseStack, projectionMatrix, partialTick, 3000, 10842, 90.0f, 0.0f, ticks, setupFog);
            EverwinterSkyRenderer.renderHorizonGlow(poseStack, projectionMatrix, partialTick, ticks);
            Setup.renderMoon(poseStack, projectionMatrix, partialTick, 250.0f, -3618616, true, false);
            return true;
        }
        return false;
    };

    public static void renderMoon(PoseStack poseStack, Matrix4f projectionMatrix, float partialTick, float size, int color, boolean phase, boolean constant) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        float r = size / 2.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        if (phase) {
            int i0 = level.m_46941_();
            int i1 = i0 & 3;
            int i2 = i0 >> 2 & 1;
            u0 = (float)i1 / 4.0f;
            v0 = (float)i2 / 2.0f;
            u1 = (float)(i1 + 1) / 4.0f;
            v1 = (float)(i2 + 1) / 2.0f;
        }
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= 1.0f - level.m_46722_(partialTick);
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(level.m_46942_(partialTick) * 360.0f));
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)alpha);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft", "textures/environment/moon_phases.png"));
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix4f, -r, -100.0f, -r).m_7421_(u1, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, -r, -100.0f, r).m_7421_(u0, v1).m_5752_();
        bufferBuilder.m_252986_(matrix4f, r, -100.0f, r).m_7421_(u0, v0).m_5752_();
        bufferBuilder.m_252986_(matrix4f, r, -100.0f, -r).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    public static DimensionSpecialEffects createEverwinterEffects(boolean constantWhiteLight, boolean constantAmbientLight, boolean fog) {
        return new JaamsEverwinterModDimensionSpecialEffects(Float.NaN, false, DimensionSpecialEffects.SkyType.NONE, constantWhiteLight, true){

            public Vec3 m_5927_(Vec3 color, float sunHeight) {
                return new Vec3(0.1, 0.1, 0.1);
            }

            public boolean m_5781_(int x, int y) {
                return true;
            }

            public float m_108871_() {
                return Float.NaN;
            }
        };
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void setupDimensions(RegisterDimensionSpecialEffectsEvent event) {
        JaamsEverwinterModDimensionSpecialEffects.CUSTOM_SKY.add(EVERWINTER_SKY_RENDERER);
        event.register(new ResourceLocation("jaams_everwinter", "everwinter"), Setup.createEverwinterEffects(false, false, true));
    }

    public static abstract class JaamsEverwinterModDimensionSpecialEffects
    extends DimensionSpecialEffects {
        public static final Set<Predicate<Object[]>> CUSTOM_SKY = new HashSet<Predicate<Object[]>>();

        public JaamsEverwinterModDimensionSpecialEffects(float cloudHeight, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
            super(cloudHeight, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (CUSTOM_SKY != null && !CUSTOM_SKY.isEmpty()) {
                boolean flag = false;
                Object[] objects = new Object[]{level, ticks, Float.valueOf(partialTick), poseStack, camera, projectionMatrix, isFoggy, setupFog};
                for (Predicate<Object[]> predicate : CUSTOM_SKY) {
                    RenderSystem.depthMask((boolean)false);
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableCull();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    flag |= predicate.test(objects);
                }
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableBlend();
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.depthMask((boolean)true);
                return flag;
            }
            return true;
        }
    }
}

