/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter.entity;

import javax.annotation.Nullable;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModEntities;
import net.jaams.jaamseverwinter.init.JaamsEverwinterModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class IceriteRockProjectileEntity
extends AbstractArrow
implements ItemSupplier {
    @Nullable
    private BlockState lastState;
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)JaamsEverwinterModItems.ICERITE_ROCK.get());

    public IceriteRockProjectileEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)JaamsEverwinterModEntities.ICERITE_ROCK_PROJECTILE.get(), world);
    }

    public IceriteRockProjectileEntity(EntityType<? extends IceriteRockProjectileEntity> type, Level world) {
        super(type, world);
    }

    public IceriteRockProjectileEntity(EntityType<? extends IceriteRockProjectileEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public IceriteRockProjectileEntity(EntityType<? extends IceriteRockProjectileEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.getPersistentData().m_128471_("isMeteor")) {
            Vec3 motion = this.m_20184_();
            double acceleration = 0.05;
            this.m_20334_(motion.f_82479_, motion.f_82480_ - acceleration, motion.f_82481_);
            if (motion.f_82480_ < -2.0) {
                this.m_20334_(motion.f_82479_, -2.0, motion.f_82481_);
            }
            if (!this.m_20069_() && !this.f_36703_ && this.f_19796_.m_188503_(3) == 0) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.15, this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 0.15, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.15, 1, 0.0, 0.05, 0.0, 0.0);
            }
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        this.lastState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36793_(false);
        if (!this.m_9236_().m_5776_()) {
            float dropChance;
            if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos pos = blockHitResult.m_82425_();
                Direction face = blockHitResult.m_82434_();
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 0.5;
                double z = (double)pos.m_123343_() + 0.5;
                switch (face) {
                    case UP: {
                        y = (double)pos.m_123342_() + 1.0 + 0.05;
                        break;
                    }
                    case DOWN: {
                        y = (double)pos.m_123342_() - 0.05;
                        break;
                    }
                    case NORTH: {
                        z = (double)pos.m_123343_() - 0.05;
                        break;
                    }
                    case SOUTH: {
                        z = (double)pos.m_123343_() + 1.0 + 0.05;
                        break;
                    }
                    case WEST: {
                        x = (double)pos.m_123341_() - 0.05;
                        break;
                    }
                    case EAST: {
                        x = (double)pos.m_123341_() + 1.0 + 0.05;
                    }
                }
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, PROJECTILE_ITEM), x, y, z, 4, 0.1, 0.1, 0.1, 0.05);
            }
            float f = dropChance = this.getPersistentData().m_128471_("isMeteor") ? 0.05f : 0.1f;
            if (this.f_19796_.m_188501_() < dropChance) {
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), new ItemStack((ItemLike)JaamsEverwinterModItems.ICERITE_CRYSTAL.get()));
                itemEntity.m_32060_();
                this.m_9236_().m_7967_((Entity)itemEntity);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11983_;
    }

    protected void m_5790_(EntityHitResult result) {
        Player player;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity.m_9236_() != null && !this.m_9236_().f_46443_) {
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            this.m_146870_();
        }
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
        if (!this.m_9236_().f_46443_) {
            entity.m_6469_(this.m_9236_().m_269111_().m_269109_(), 2.0f);
            RandomSource random = this.m_9236_().m_213780_();
            if (random.m_188501_() < 0.5f) {
                int slownessLevel = 2 + random.m_188503_(2);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, slownessLevel));
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, PROJECTILE_ITEM), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_() / 2.0, entity.m_20189_(), 0.0, 0.1, 0.0);
        }
    }

    public static IceriteRockProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return IceriteRockProjectileEntity.shoot(world, entity, source, 0.75f, 3.0, 0);
    }

    public static IceriteRockProjectileEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return IceriteRockProjectileEntity.shoot(world, entity, source, pullingPower * 0.75f, 3.0, 0);
    }

    public static IceriteRockProjectileEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        IceriteRockProjectileEntity entityarrow = new IceriteRockProjectileEntity((EntityType<? extends IceriteRockProjectileEntity>)((EntityType)JaamsEverwinterModEntities.ICERITE_ROCK_PROJECTILE.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 1.5f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static IceriteRockProjectileEntity shoot(LivingEntity entity, LivingEntity target) {
        IceriteRockProjectileEntity entityarrow = new IceriteRockProjectileEntity((EntityType<? extends IceriteRockProjectileEntity>)((EntityType)JaamsEverwinterModEntities.ICERITE_ROCK_PROJECTILE.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.125f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(3.0);
        entityarrow.m_36735_(0);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.arrow.shoot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

