/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter.init;

import net.jaams.jaamseverwinter.entity.CrybabyEntity;
import net.jaams.jaamseverwinter.entity.IceriteRockProjectileEntity;
import net.jaams.jaamseverwinter.entity.MockerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JaamsEverwinterModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"jaams_everwinter");
    public static final RegistryObject<EntityType<CrybabyEntity>> CRYBABY = JaamsEverwinterModEntities.register("crybaby", EntityType.Builder.m_20704_(CrybabyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CrybabyEntity::new).m_20699_(0.6f, 1.2f));
    public static final RegistryObject<EntityType<MockerEntity>> MOCKER = JaamsEverwinterModEntities.register("mocker", EntityType.Builder.m_20704_(MockerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MockerEntity::new).m_20699_(0.6f, 1.4f));
    public static final RegistryObject<EntityType<IceriteRockProjectileEntity>> ICERITE_ROCK_PROJECTILE = JaamsEverwinterModEntities.register("icerite_rock_projectile", EntityType.Builder.m_20704_(IceriteRockProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(IceriteRockProjectileEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CrybabyEntity.init();
            MockerEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CRYBABY.get(), CrybabyEntity.createAttributes().m_22265_());
        event.put((EntityType)MOCKER.get(), MockerEntity.createAttributes().m_22265_());
    }
}

