/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaamseverwinter.item;

import java.util.List;
import javax.annotation.Nullable;
import net.jaams.jaamseverwinter.JaamsEverwinterMod;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class FrozenOcarinaItem
extends Item {
    public static final ResourceKey<Level> EVERWINTER_DIMENSION = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("minecraft:dimension")), (ResourceLocation)new ResourceLocation("jaams_everwinter", "everwinter"));

    public FrozenOcarinaItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.m_46472_().equals(EVERWINTER_DIMENSION)) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12212_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                serverPlayer.m_36335_().m_41524_((Item)this, 40);
                this.spawnSnowParticles(serverLevel, serverPlayer);
                JaamsEverwinterMod.queueServerWork(3, () -> {
                    itemstack.m_41774_(1);
                    serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
                });
                JaamsEverwinterMod.queueServerWork(10, () -> {
                    ServerLevel overworld = serverLevel.m_7654_().m_129880_(Level.f_46428_);
                    if (overworld != null) {
                        BlockPos safePos = this.findSafeTeleportLocation(overworld, new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_()));
                        if (safePos != null) {
                            serverPlayer.m_8999_(overworld, (double)safePos.m_123341_() + 0.5, (double)safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                        } else {
                            BlockPos spawnPos = overworld.m_220360_();
                            serverPlayer.m_8999_(overworld, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                        }
                    }
                });
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)"Teleports you from ").m_7220_((Component)Component.m_237113_((String)"Everwinter").m_130940_(ChatFormatting.BLUE)).m_7220_((Component)Component.m_237113_((String)" to the Overworld. Breaks after use.")).m_130940_(ChatFormatting.WHITE));
    }

    private void spawnSnowParticles(ServerLevel level, ServerPlayer player) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 30; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 2.0;
            double offsetY = random.m_188500_() * 2.0;
            double offsetZ = (random.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_175821_, player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private BlockPos findSafeTeleportLocation(ServerLevel level, BlockPos startPos) {
        RandomSource random = level.f_46441_;
        int searchRadius = 16;
        int maxAttempts = 10;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            int z;
            int y;
            int x = startPos.m_123341_() + random.m_188503_(searchRadius * 2 + 1) - searchRadius;
            BlockPos pos = new BlockPos(x, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = startPos.m_123343_() + random.m_188503_(searchRadius * 2 + 1) - searchRadius), z);
            if (!this.isSafeLocation(level, pos)) continue;
            return pos;
        }
        return null;
    }

    private boolean isSafeLocation(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return below.m_280296_() && !at.m_280296_() && !above.m_280296_() && !below.m_60713_(Blocks.f_49991_) && !at.m_60713_(Blocks.f_49991_) && !above.m_60713_(Blocks.f_49991_) && !below.m_60713_(Blocks.f_49990_) && !at.m_60713_(Blocks.f_49990_) && !above.m_60713_(Blocks.f_49990_);
    }
}

