/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.doaebw.entity;

import net.mcreator.doaebw.entity.AlizeeEntity;
import net.mcreator.doaebw.entity.AxeVillagerEntity;
import net.mcreator.doaebw.entity.HammerVillagerEntity;
import net.mcreator.doaebw.entity.MinusEntity;
import net.mcreator.doaebw.entity.SwordVillagerEntity;
import net.mcreator.doaebw.init.DiaryOfAnEightBitWarriorModEntities;
import net.mcreator.doaebw.procedures.GhoulNaturalEntitySpawningConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class UltraCreeperEntity
extends Monster {
    public UltraCreeperEntity(EntityType<UltraCreeperEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, ServerPlayer.class, false, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AxeVillagerEntity.class, false, false));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, HammerVillagerEntity.class, false, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, SwordVillagerEntity.class, false, false));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, AlizeeEntity.class, false, false));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, MinusEntity.class, false, false));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractGolem.class, false, false));
        this.targetSelector.addGoal(11, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(12, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(13, (Goal)new BreakDoorGoal((Mob)this, e -> true));
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(15, (Goal)new FloatGoal((Mob)this));
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float f) {
        return super.getPassengerAttachmentPoint(entity, dimensions, f).add(0.0, (double)-0.1f, 0.0);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)Items.GUNPOWDER));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.creeper.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.creeper.death"));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DiaryOfAnEightBitWarriorModEntities.ULTRA_CREEPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return GhoulNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 15.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 50.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

