/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.doaebw.network;

import java.util.HashMap;
import net.mcreator.doaebw.DiaryOfAnEightBitWarriorMod;
import net.mcreator.doaebw.procedures.CheckIsUnderworldProcedure;
import net.mcreator.doaebw.procedures.CheckisVoidProcedure;
import net.mcreator.doaebw.world.inventory.DEVGUI3Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DEVGUI3ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DEVGUI3ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diary_of_an_eight_bit_warrior", (String)"devgui_3_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DEVGUI3ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new DEVGUI3ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DEVGUI3ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(DEVGUI3ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                DEVGUI3ButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = DEVGUI3Menu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CheckisVoidProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            CheckIsUnderworldProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DiaryOfAnEightBitWarriorMod.addNetworkMessage(TYPE, STREAM_CODEC, DEVGUI3ButtonMessage::handleData);
    }
}

