/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.doaebw.network;

import java.util.function.Supplier;
import net.mcreator.doaebw.DiaryOfAnEightBitWarriorMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DiaryOfAnEightBitWarriorModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"diary_of_an_eight_bit_warrior");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        DiaryOfAnEightBitWarriorMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        DiaryOfAnEightBitWarriorMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diary_of_an_eight_bit_warrior", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"diary_of_an_eight_bit_warrior", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double playerSpawnLocationX = 0.0;
        public double playerSpawnLocationY = 0.0;
        public double playerSpawnLocationZ = 0.0;
        public boolean dim_ambience_on = false;
        public double dash_variable = 0.0;
        public double fireballer_variable = 0.0;
        public double hide_variable = 0.0;
        public double dualwield_variable = 0.0;
        public String PlayerCurrentXP = "\"\"";
        public double dwarvengrace_on = 0.0;
        public double wario_bundle_new = 0.0;
        public String recipeName = "\"\"";
        public double pageNumber = 1.0;
        public String pageNumberText = "\"\"";
        public boolean mask_float = false;
        public boolean brio_damaged = false;
        public boolean isUnderworld = false;
        public boolean isVoid = false;
        public boolean healthbartoggle = true;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("playerSpawnLocationX", this.playerSpawnLocationX);
            nbt.putDouble("playerSpawnLocationY", this.playerSpawnLocationY);
            nbt.putDouble("playerSpawnLocationZ", this.playerSpawnLocationZ);
            nbt.putBoolean("dim_ambience_on", this.dim_ambience_on);
            nbt.putDouble("dash_variable", this.dash_variable);
            nbt.putDouble("fireballer_variable", this.fireballer_variable);
            nbt.putDouble("hide_variable", this.hide_variable);
            nbt.putDouble("dualwield_variable", this.dualwield_variable);
            nbt.putString("PlayerCurrentXP", this.PlayerCurrentXP);
            nbt.putDouble("dwarvengrace_on", this.dwarvengrace_on);
            nbt.putDouble("wario_bundle_new", this.wario_bundle_new);
            nbt.putString("recipeName", this.recipeName);
            nbt.putDouble("pageNumber", this.pageNumber);
            nbt.putString("pageNumberText", this.pageNumberText);
            nbt.putBoolean("mask_float", this.mask_float);
            nbt.putBoolean("brio_damaged", this.brio_damaged);
            nbt.putBoolean("isUnderworld", this.isUnderworld);
            nbt.putBoolean("isVoid", this.isVoid);
            nbt.putBoolean("healthbartoggle", this.healthbartoggle);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.playerSpawnLocationX = nbt.getDouble("playerSpawnLocationX");
            this.playerSpawnLocationY = nbt.getDouble("playerSpawnLocationY");
            this.playerSpawnLocationZ = nbt.getDouble("playerSpawnLocationZ");
            this.dim_ambience_on = nbt.getBoolean("dim_ambience_on");
            this.dash_variable = nbt.getDouble("dash_variable");
            this.fireballer_variable = nbt.getDouble("fireballer_variable");
            this.hide_variable = nbt.getDouble("hide_variable");
            this.dualwield_variable = nbt.getDouble("dualwield_variable");
            this.PlayerCurrentXP = nbt.getString("PlayerCurrentXP");
            this.dwarvengrace_on = nbt.getDouble("dwarvengrace_on");
            this.wario_bundle_new = nbt.getDouble("wario_bundle_new");
            this.recipeName = nbt.getString("recipeName");
            this.pageNumber = nbt.getDouble("pageNumber");
            this.pageNumberText = nbt.getString("pageNumberText");
            this.mask_float = nbt.getBoolean("mask_float");
            this.brio_damaged = nbt.getBoolean("brio_damaged");
            this.isUnderworld = nbt.getBoolean("isUnderworld");
            this.isVoid = nbt.getBoolean("isVoid");
            this.healthbartoggle = nbt.getBoolean("healthbartoggle");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "diary_of_an_eight_bit_warrior_mapvars";
        public boolean sit = false;
        public boolean gui_opened = false;
        public boolean timer = true;
        public boolean Dragon_Dead = false;
        public boolean fermentanim = false;
        public boolean portal_sculk_activated = false;
        public boolean firsttime = false;
        public boolean shieldactive = false;
        public boolean part1done = false;
        public boolean part2done = false;
        public boolean part3done = false;
        public boolean part4done = false;
        public boolean part5done = false;
        public boolean part6done = false;
        public boolean part7done = false;
        public boolean part8done = false;
        public boolean part9done = false;
        public boolean part10done = false;
        public boolean part11done = false;
        public boolean part12done = false;
        public boolean part13done = false;
        public boolean part14done = false;
        public boolean part15done = false;
        public boolean part16done = false;
        public boolean jello0 = false;
        public boolean jello1 = false;
        public boolean jello2 = false;
        public boolean jello3 = false;
        public boolean jello4 = false;
        public boolean jello5 = false;
        public boolean jello6 = false;
        public boolean jello7 = false;
        public boolean jello8 = false;
        public boolean jello9 = false;
        public boolean jello10 = false;
        public boolean jello11 = false;
        public boolean jello12 = false;
        public boolean jello13 = false;
        public boolean jelloanimtrue = false;
        public boolean plainslocated = false;
        public double plains_x = 0.0;
        public double plains_z = 0.0;
        public double LoadingStageNum = 0.0;
        public double RandomTipNum = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.sit = nbt.getBoolean("sit");
            this.gui_opened = nbt.getBoolean("gui_opened");
            this.timer = nbt.getBoolean("timer");
            this.Dragon_Dead = nbt.getBoolean("Dragon_Dead");
            this.fermentanim = nbt.getBoolean("fermentanim");
            this.portal_sculk_activated = nbt.getBoolean("portal_sculk_activated");
            this.firsttime = nbt.getBoolean("firsttime");
            this.shieldactive = nbt.getBoolean("shieldactive");
            this.part1done = nbt.getBoolean("part1done");
            this.part2done = nbt.getBoolean("part2done");
            this.part3done = nbt.getBoolean("part3done");
            this.part4done = nbt.getBoolean("part4done");
            this.part5done = nbt.getBoolean("part5done");
            this.part6done = nbt.getBoolean("part6done");
            this.part7done = nbt.getBoolean("part7done");
            this.part8done = nbt.getBoolean("part8done");
            this.part9done = nbt.getBoolean("part9done");
            this.part10done = nbt.getBoolean("part10done");
            this.part11done = nbt.getBoolean("part11done");
            this.part12done = nbt.getBoolean("part12done");
            this.part13done = nbt.getBoolean("part13done");
            this.part14done = nbt.getBoolean("part14done");
            this.part15done = nbt.getBoolean("part15done");
            this.part16done = nbt.getBoolean("part16done");
            this.jello0 = nbt.getBoolean("jello0");
            this.jello1 = nbt.getBoolean("jello1");
            this.jello2 = nbt.getBoolean("jello2");
            this.jello3 = nbt.getBoolean("jello3");
            this.jello4 = nbt.getBoolean("jello4");
            this.jello5 = nbt.getBoolean("jello5");
            this.jello6 = nbt.getBoolean("jello6");
            this.jello7 = nbt.getBoolean("jello7");
            this.jello8 = nbt.getBoolean("jello8");
            this.jello9 = nbt.getBoolean("jello9");
            this.jello10 = nbt.getBoolean("jello10");
            this.jello11 = nbt.getBoolean("jello11");
            this.jello12 = nbt.getBoolean("jello12");
            this.jello13 = nbt.getBoolean("jello13");
            this.jelloanimtrue = nbt.getBoolean("jelloanimtrue");
            this.plainslocated = nbt.getBoolean("plainslocated");
            this.plains_x = nbt.getDouble("plains_x");
            this.plains_z = nbt.getDouble("plains_z");
            this.LoadingStageNum = nbt.getDouble("LoadingStageNum");
            this.RandomTipNum = nbt.getDouble("RandomTipNum");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("sit", this.sit);
            nbt.putBoolean("gui_opened", this.gui_opened);
            nbt.putBoolean("timer", this.timer);
            nbt.putBoolean("Dragon_Dead", this.Dragon_Dead);
            nbt.putBoolean("fermentanim", this.fermentanim);
            nbt.putBoolean("portal_sculk_activated", this.portal_sculk_activated);
            nbt.putBoolean("firsttime", this.firsttime);
            nbt.putBoolean("shieldactive", this.shieldactive);
            nbt.putBoolean("part1done", this.part1done);
            nbt.putBoolean("part2done", this.part2done);
            nbt.putBoolean("part3done", this.part3done);
            nbt.putBoolean("part4done", this.part4done);
            nbt.putBoolean("part5done", this.part5done);
            nbt.putBoolean("part6done", this.part6done);
            nbt.putBoolean("part7done", this.part7done);
            nbt.putBoolean("part8done", this.part8done);
            nbt.putBoolean("part9done", this.part9done);
            nbt.putBoolean("part10done", this.part10done);
            nbt.putBoolean("part11done", this.part11done);
            nbt.putBoolean("part12done", this.part12done);
            nbt.putBoolean("part13done", this.part13done);
            nbt.putBoolean("part14done", this.part14done);
            nbt.putBoolean("part15done", this.part15done);
            nbt.putBoolean("part16done", this.part16done);
            nbt.putBoolean("jello0", this.jello0);
            nbt.putBoolean("jello1", this.jello1);
            nbt.putBoolean("jello2", this.jello2);
            nbt.putBoolean("jello3", this.jello3);
            nbt.putBoolean("jello4", this.jello4);
            nbt.putBoolean("jello5", this.jello5);
            nbt.putBoolean("jello6", this.jello6);
            nbt.putBoolean("jello7", this.jello7);
            nbt.putBoolean("jello8", this.jello8);
            nbt.putBoolean("jello9", this.jello9);
            nbt.putBoolean("jello10", this.jello10);
            nbt.putBoolean("jello11", this.jello11);
            nbt.putBoolean("jello12", this.jello12);
            nbt.putBoolean("jello13", this.jello13);
            nbt.putBoolean("jelloanimtrue", this.jelloanimtrue);
            nbt.putBoolean("plainslocated", this.plainslocated);
            nbt.putDouble("plains_x", this.plains_x);
            nbt.putDouble("plains_z", this.plains_z);
            nbt.putDouble("LoadingStageNum", this.LoadingStageNum);
            nbt.putDouble("RandomTipNum", this.RandomTipNum);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "diary_of_an_eight_bit_warrior_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.playerSpawnLocationX = original.playerSpawnLocationX;
            clone.playerSpawnLocationY = original.playerSpawnLocationY;
            clone.playerSpawnLocationZ = original.playerSpawnLocationZ;
            clone.dash_variable = original.dash_variable;
            clone.fireballer_variable = original.fireballer_variable;
            clone.hide_variable = original.hide_variable;
            clone.dualwield_variable = original.dualwield_variable;
            clone.dwarvengrace_on = original.dwarvengrace_on;
            clone.wario_bundle_new = original.wario_bundle_new;
            clone.mask_float = original.mask_float;
            clone.brio_damaged = original.brio_damaged;
            clone.isUnderworld = original.isUnderworld;
            clone.isVoid = original.isVoid;
            clone.healthbartoggle = original.healthbartoggle;
            if (!event.isWasDeath()) {
                clone.dim_ambience_on = original.dim_ambience_on;
                clone.PlayerCurrentXP = original.PlayerCurrentXP;
                clone.recipeName = original.recipeName;
                clone.pageNumber = original.pageNumber;
                clone.pageNumberText = original.pageNumberText;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

