/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.labyrinth;

import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.mcreator.labyrinth.entity.ExaminerEntity;
import net.mcreator.labyrinth.entity.ResearcherEntity;
import net.mcreator.labyrinth.entity.VenenumEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class BonePositionPacket {
    private final String boneName;
    private final Vec3 position;

    public BonePositionPacket(String boneName, Vec3 position) {
        this.boneName = boneName;
        this.position = position;
    }

    public static void encode(BonePositionPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.boneName);
        buffer.writeDouble(packet.position.f_82479_);
        buffer.writeDouble(packet.position.f_82480_);
        buffer.writeDouble(packet.position.f_82481_);
    }

    public static BonePositionPacket decode(FriendlyByteBuf buffer) {
        String boneName = buffer.m_130277_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        return new BonePositionPacket(boneName, new Vec3(x, y, z));
    }

    public String getBoneName() {
        return this.boneName;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public static void handle(BonePositionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                ResearcherEntity researcher;
                VenenumEntity venenum;
                ServerLevel level = player.m_284548_().m_6018_();
                ExaminerEntity examiner = BonePositionPacket.findNearestExaminer(level, player.m_20182_());
                if (examiner != null) {
                    examiner.setBonePosition(packet.getBoneName(), packet.getPosition());
                }
                if ((venenum = BonePositionPacket.findNearestVenenum(level, player.m_20182_())) != null) {
                    venenum.setBonePosition(packet.getBoneName(), packet.getPosition());
                }
                if ((researcher = BonePositionPacket.findNearestResearcher(level, player.m_20182_())) != null) {
                    researcher.setBonePosition(packet.getBoneName(), packet.getPosition());
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static ExaminerEntity findNearestExaminer(ServerLevel level, Vec3 position) {
        List examiner = level.m_45976_(ExaminerEntity.class, new AABB(position.m_82492_(1000.0, 1000.0, 1000.0), position.m_82520_(1000.0, 1000.0, 1000.0)));
        return examiner.stream().min(Comparator.comparingDouble(e -> e.m_20238_(position))).orElse(null);
    }

    private static VenenumEntity findNearestVenenum(ServerLevel level, Vec3 position) {
        List examiner = level.m_45976_(VenenumEntity.class, new AABB(position.m_82492_(1000.0, 1000.0, 1000.0), position.m_82520_(1000.0, 1000.0, 1000.0)));
        return examiner.stream().min(Comparator.comparingDouble(e -> e.m_20238_(position))).orElse(null);
    }

    private static ResearcherEntity findNearestResearcher(ServerLevel level, Vec3 position) {
        List examiner = level.m_45976_(ResearcherEntity.class, new AABB(position.m_82492_(1000.0, 1000.0, 1000.0), position.m_82520_(1000.0, 1000.0, 1000.0)));
        return examiner.stream().min(Comparator.comparingDouble(e -> e.m_20238_(position))).orElse(null);
    }
}

