/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.labyrinth;

import net.mcreator.labyrinth.init.LabyrinthModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;

public class CameraShake
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> MAGNITUDE = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FADE_DURATION = SynchedEntityData.m_135353_(CameraShake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CameraShake(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public CameraShake(EntityType<?> type, Level level, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        this(type, level);
        this.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        this.setRadius(radius);
        this.setMagnitude(magnitude);
        this.setDuration(duration);
        this.setFadeDuration(fadeDuration);
    }

    public CameraShake(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType)LabyrinthModEntities.CAMERA_SHAKE.get(), world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(MAGNITUDE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(FADE_DURATION, (Object)5);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.getDuration() + this.getFadeDuration()) {
            this.m_146870_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAmount(Player player, float partialTick) {
        float intensity;
        float timePassed = (float)this.f_19797_ + partialTick;
        if (timePassed < (float)this.getDuration()) {
            intensity = this.getMagnitude();
        } else {
            float fadeProgress = 1.0f - (timePassed - (float)this.getDuration()) / ((float)this.getFadeDuration() + 1.0f);
            intensity = fadeProgress * fadeProgress * this.getMagnitude();
        }
        Vec3 playerPos = player.m_20299_(partialTick);
        float distance = (float)this.m_20182_().m_82554_(playerPos);
        float distanceFactor = 1.0f - Mth.m_14036_((float)(distance / this.getRadius()), (float)0.0f, (float)1.0f);
        return intensity * distanceFactor * distanceFactor;
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getMagnitude() {
        return ((Float)this.f_19804_.m_135370_(MAGNITUDE)).floatValue();
    }

    public void setMagnitude(float magnitude) {
        this.f_19804_.m_135381_(MAGNITUDE, (Object)Float.valueOf(magnitude));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DURATION, (Object)duration);
    }

    public int getFadeDuration() {
        return (Integer)this.f_19804_.m_135370_(FADE_DURATION);
    }

    public void setFadeDuration(int fadeDuration) {
        this.f_19804_.m_135381_(FADE_DURATION, (Object)fadeDuration);
    }

    protected void m_7378_(CompoundTag tag) {
        this.setRadius(tag.m_128457_("Radius"));
        this.setMagnitude(tag.m_128457_("Magnitude"));
        this.setDuration(tag.m_128451_("Duration"));
        this.setFadeDuration(tag.m_128451_("FadeDuration"));
        this.f_19797_ = tag.m_128451_("TicksExisted");
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128350_("Radius", this.getRadius());
        tag.m_128350_("Magnitude", this.getMagnitude());
        tag.m_128405_("Duration", this.getDuration());
        tag.m_128405_("FadeDuration", this.getFadeDuration());
        tag.m_128405_("TicksExisted", this.f_19797_);
    }

    public static void createCameraShake(Level level, Vec3 position, float radius, float magnitude, int duration, int fadeDuration) {
        if (!level.m_5776_()) {
            CameraShake shakeEntity = new CameraShake(EntityType.f_147036_, level, position, radius, magnitude, duration, fadeDuration);
            level.m_7967_((Entity)shakeEntity);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = new AttributeSupplier.Builder();
        return builder;
    }

    public static void init() {
    }
}

