/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.labyrinth;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mcreator.labyrinth.CameraShake;
import net.mcreator.labyrinth.CameraShakeRenderer;
import net.mcreator.labyrinth.ModMessage;
import net.mcreator.labyrinth.init.LabyrinthModEntities;
import net.mcreator.labyrinth.init.LabyrinthModItems;
import net.mcreator.labyrinth.init.LabyrinthModMobEffects;
import net.mcreator.labyrinth.init.LabyrinthModParticleTypes;
import net.mcreator.labyrinth.init.LabyrinthModSounds;
import net.mcreator.labyrinth.init.LabyrinthModTabs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="labyrinth")
public class LabyrinthMod {
    public static final Logger LOGGER = LogManager.getLogger(LabyrinthMod.class);
    public static final String MODID = "labyrinth";
    public static SimpleChannel NETWORK;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER;
    private static int messageID;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue;

    public LabyrinthMod() {
        ModMessage.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        LabyrinthModSounds.REGISTRY.register(bus);
        LabyrinthModItems.REGISTRY.register(bus);
        LabyrinthModEntities.REGISTRY.register(bus);
        LabyrinthModTabs.REGISTRY.register(bus);
        LabyrinthModMobEffects.REGISTRY.register(bus);
        LabyrinthModParticleTypes.REGISTRY.register(bus);
    }

    @SubscribeEvent
    public void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        if (player != null && !Minecraft.m_91087_().m_91104_()) {
            float shakeAmplitude = 0.0f;
            for (CameraShake cameraShake : player.m_9236_().m_45976_(CameraShake.class, player.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    static {
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        messageID = 0;
        workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientSetup {
        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)LabyrinthModEntities.CAMERA_SHAKE.get(), CameraShakeRenderer::new);
        }
    }
}

