/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.labyrinth.client.particle;

import net.mcreator.labyrinth.procedures.DeathParticleVisualScaleProcedure;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeathParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private float angularVelocity;
    private float angularAcceleration;

    public static DeathParticleProvider provider(SpriteSet spriteSet) {
        return new DeathParticleProvider(spriteSet);
    }

    protected DeathParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.m_107250_(0.2f, 0.2f);
        this.f_107225_ = Math.max(4, 10 + (this.f_107223_.m_188503_(10) - 5));
        this.f_107226_ = 0.1f;
        this.f_107219_ = false;
        this.f_107215_ = vx * 2.0;
        this.f_107216_ = vy * 4.0;
        this.f_107217_ = vz * 2.0;
        this.angularVelocity = 0.4f;
        this.angularAcceleration = 0.0f;
        this.m_107271_(1.0f);
        this.m_108335_(spriteSet);
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float m_5902_(float scale) {
        ClientLevel world = this.f_107208_;
        return super.m_5902_(scale) * (float)DeathParticleVisualScaleProcedure.execute();
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.angularVelocity;
        this.angularVelocity += this.angularAcceleration;
        float lifeCoeff = (float)this.f_107224_ / (float)this.f_107225_;
        this.f_107230_ = lifeCoeff < 0.7f ? 1.0f : 1.0f - (lifeCoeff - 0.7f) / 0.3f;
        this.f_107663_ *= 1.0f - 0.1f * lifeCoeff;
        if (this.f_107224_ % 2 == 0) {
            this.f_107215_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.02f);
            this.f_107217_ += (double)((this.f_107223_.m_188501_() - 0.5f) * 0.02f);
        }
        this.f_107216_ *= (double)0.95f;
    }

    public static class DeathParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public DeathParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DeathParticle particle = new DeathParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

