/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.labyrinth.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.labyrinth.BonePositionPacket;
import net.mcreator.labyrinth.ModMessage;
import net.mcreator.labyrinth.ModelPartUtils;
import net.mcreator.labyrinth.client.model.ModelExaminer;
import net.mcreator.labyrinth.client.model.animations.Examiner1Animation;
import net.mcreator.labyrinth.client.model.animations.ExaminerAnimation;
import net.mcreator.labyrinth.entity.ExaminerEntity;
import net.mcreator.labyrinth.procedures.ExaminerDisplayConditionProcedure;
import net.mcreator.labyrinth.procedures.ExaminerPlaybackConditionProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExaminerRenderer
extends MobRenderer<ExaminerEntity, ModelExaminer<ExaminerEntity>> {
    private static final String[] SHIELD_PATH = new String[]{"roots", "arm2", "ar2", "shield"};
    private static final String[] MACE_PATH = new String[]{"roots", "arm1", "ar1", "mace", "mace2"};
    private static final String[] SWORD_PATH = new String[]{"roots", "arm1", "ar1", "sword", "sword1"};
    private static final String[] LEFT_LEG_PATH = new String[]{"leg1"};
    private static final String[] RIGHT_LEG_PATH = new String[]{"leg2"};

    public ExaminerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.m_174023_(ModelExaminer.LAYER_LOCATION)), 0.8f);
        this.m_115326_((RenderLayer)new RenderLayer<ExaminerEntity, ModelExaminer<ExaminerEntity>>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = new ResourceLocation("labyrinth:textures/entities/examinerg.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ExaminerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Vec3 shieldPos = ModelPartUtils.getWorldPositionCenter((Entity)entity, entity.f_20883_, ((ModelExaminer)ExaminerRenderer.this.f_115290_).root(), SHIELD_PATH);
                Vec3 macePos = ModelPartUtils.getWorldPositionCenter((Entity)entity, entity.f_20883_, ((ModelExaminer)ExaminerRenderer.this.f_115290_).root(), MACE_PATH);
                Vec3 leg1Pos = ModelPartUtils.getWorldPositionCenter((Entity)entity, entity.f_20883_, ((ModelExaminer)ExaminerRenderer.this.f_115290_).root(), RIGHT_LEG_PATH);
                Vec3 leg2Pos = ModelPartUtils.getWorldPositionCenter((Entity)entity, entity.f_20883_, ((ModelExaminer)ExaminerRenderer.this.f_115290_).root(), LEFT_LEG_PATH);
                Vec3 swordPos = ModelPartUtils.getWorldPositionCenter((Entity)entity, entity.f_20883_, ((ModelExaminer)ExaminerRenderer.this.f_115290_).root(), SWORD_PATH);
                ModMessage.sendToServer(new BonePositionPacket("mace2", new Vec3(macePos.f_82479_, macePos.f_82480_, macePos.f_82481_)));
                ModMessage.sendToServer(new BonePositionPacket("shield", new Vec3(shieldPos.f_82479_, shieldPos.f_82480_, shieldPos.f_82481_)));
                ModMessage.sendToServer(new BonePositionPacket("leg1", new Vec3(leg1Pos.f_82479_, leg1Pos.f_82480_, leg1Pos.f_82481_)));
                ModMessage.sendToServer(new BonePositionPacket("leg2", new Vec3(leg2Pos.f_82479_, leg2Pos.f_82480_, leg2Pos.f_82481_)));
                ModMessage.sendToServer(new BonePositionPacket("sword1", new Vec3(swordPos.f_82479_, swordPos.f_82480_, swordPos.f_82481_)));
                Level world = entity.m_9236_();
                double x = entity.m_20185_();
                double y = entity.m_20186_();
                double z = entity.m_20189_();
                if (ExaminerDisplayConditionProcedure.execute()) {
                    VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)this.LAYER_TEXTURE));
                    ModelExaminer model = new ModelExaminer(Minecraft.m_91087_().m_167973_().m_171103_(ModelExaminer.LAYER_LOCATION));
                    ((ModelExaminer)this.m_117386_()).m_102624_(model);
                    model.m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                    model.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        });
    }

    protected void scale(ExaminerEntity entity, PoseStack poseStack, float f) {
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
    }

    public ResourceLocation getTextureLocation(ExaminerEntity entity) {
        return new ResourceLocation("labyrinth:textures/entities/examiner.png");
    }

    protected boolean isShaking(ExaminerEntity entity) {
        return entity.getPersistentData().m_128471_("carnage");
    }

    private static final class AnimatedModel
    extends ModelExaminer<ExaminerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ExaminerEntity>(){

            public ModelPart m_142109_() {
                return root;
            }

            public void setupAnim(ExaminerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
                this.m_233385_(entity.animationState0, ExaminerAnimation.idle, ageInTicks, 1.0f);
                if (ExaminerPlaybackConditionProcedure.execute((Entity)entity)) {
                    this.m_267799_(ExaminerAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 1.7f);
                }
                this.m_233385_(entity.animationState2, ExaminerAnimation.smash, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState3, ExaminerAnimation.mace1, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState4, ExaminerAnimation.bash, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState5, ExaminerAnimation.mace2, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState6, ExaminerAnimation.bash2, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState7, ExaminerAnimation.leap, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState8, ExaminerAnimation.heal, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState9, ExaminerAnimation.sword1, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState10, ExaminerAnimation.phase2, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState11, ExaminerAnimation.sword2, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState12, ExaminerAnimation.sword3, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState13, Examiner1Animation.Stab, ageInTicks, 1.0f);
                this.m_233385_(entity.animationState14, Examiner1Animation.sword4, ageInTicks, 1.0f);
                this.m_233385_(entity.showMace, ExaminerAnimation.showMace, ageInTicks, 1.0f);
                this.m_233385_(entity.showSword, ExaminerAnimation.showSword, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(ExaminerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.m_6973_((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

