/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelCustomModel
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"epicest_mod", (String)"model_custom_model"), "main");
    public final ModelPart bone;
    public final ModelPart Head;
    public final ModelPart Body;
    public final ModelPart RightArm;
    public final ModelPart LeftArm;
    public final ModelPart RightLeg;
    public final ModelPart LeftLeg;

    public ModelCustomModel(ModelPart root) {
        super(root);
        this.bone = root.getChild("bone");
        this.Head = this.bone.getChild("Head");
        this.Body = this.bone.getChild("Body");
        this.RightArm = this.bone.getChild("RightArm");
        this.LeftArm = this.bone.getChild("LeftArm");
        this.RightLeg = this.bone.getChild("RightLeg");
        this.LeftLeg = this.bone.getChild("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)31.0f, (float)0.0f));
        PartDefinition Head = bone.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(34, 0).addBox(-3.0f, -18.0f, -5.0f, 6.0f, 3.0f, 7.0f, new CubeDeformation(-0.5f)).texOffs(0, 0).addBox(-4.0f, -25.0f, -5.0f, 8.0f, 8.0f, 9.0f, new CubeDeformation(-0.5f)), PartPose.offset((float)0.0f, (float)-31.0f, (float)0.0f));
        PartDefinition Body = bone.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(16, 30).addBox(-4.0f, 7.0f, -2.0f, 8.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 17).addBox(-6.0f, -1.0f, -3.0f, 12.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-45.0f, (float)0.0f));
        PartDefinition RightArm = bone.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(0, 30).addBox(-5.0f, -5.0f, -1.0f, 2.0f, 30.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-43.0f, (float)0.0f));
        PartDefinition LeftArm = bone.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(8, 30).addBox(1.0f, -5.0f, -1.0f, 2.0f, 30.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-43.0f, (float)0.0f));
        PartDefinition RightLeg = bone.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(40, 10).addBox(-1.0f, 6.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-33.0f, (float)0.0f));
        PartDefinition LeftLeg = bone.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(40, 36).addBox(-1.0f, 6.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-33.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

