/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.init;

import net.mcreator.epicestmod.entity.DeathShootEntity;
import net.mcreator.epicestmod.entity.HollowWalkerEntity;
import net.mcreator.epicestmod.entity.RockGolemEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EpicestModModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"epicest_mod");
    public static final DeferredHolder<EntityType<?>, EntityType<RockGolemEntity>> ROCK_GOLEM = EpicestModModEntities.register("rock_golem", EntityType.Builder.of(RockGolemEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(3.0f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DeathShootEntity>> DEATH_SHOOT = EpicestModModEntities.register("death_shoot", EntityType.Builder.of(DeathShootEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<HollowWalkerEntity>> HOLLOW_WALKER = EpicestModModEntities.register("hollow_walker", EntityType.Builder.of(HollowWalkerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 3.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"epicest_mod", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        RockGolemEntity.init(event);
        HollowWalkerEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ROCK_GOLEM.get(), RockGolemEntity.createAttributes().build());
        event.put((EntityType)HOLLOW_WALKER.get(), HollowWalkerEntity.createAttributes().build());
    }
}

