/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import net.mcreator.epicestmod.init.EpicestModModItems;
import net.mcreator.epicestmod.procedures.DeathIngotArmorBootsTickEventProcedure;
import net.mcreator.epicestmod.procedures.DeathIngotArmorChestplateTickEventProcedure;
import net.mcreator.epicestmod.procedures.DeathIngotArmorHelmetTickEventProcedure;
import net.mcreator.epicestmod.procedures.DeathIngotArmorLeggingsTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class DeathIngotArmorItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(20, Map.of(ArmorType.BOOTS, 5, ArmorType.LEGGINGS, 8, ArmorType.CHESTPLATE, 12, ArmorType.HELMET, 6, ArmorType.BODY, 12), 10, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_chain")), 3.0f, 0.2f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"epicest_mod:death_ingot_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"epicest_mod:death_ingot_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/deathingotarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.DEATH_INGOT_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/deathingotarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.DEATH_INGOT_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/deathingotarmor_layer_2.png");
            }
        }, new Item[]{(Item)EpicestModModItems.DEATH_INGOT_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/deathingotarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.DEATH_INGOT_ARMOR_BOOTS.get()});
    }

    private DeathIngotArmorItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends DeathIngotArmorItem {
        public Boots(Item.Properties properties) {
            super(ArmorType.BOOTS, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                DeathIngotArmorBootsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends DeathIngotArmorItem {
        public Leggings(Item.Properties properties) {
            super(ArmorType.LEGGINGS, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                DeathIngotArmorLeggingsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Chestplate
    extends DeathIngotArmorItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                DeathIngotArmorChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends DeathIngotArmorItem {
        public Helmet(Item.Properties properties) {
            super(ArmorType.HELMET, properties.fireResistant());
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                DeathIngotArmorHelmetTickEventProcedure.execute(entity);
            }
        }
    }
}

