/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.procedures;

import net.mcreator.epicestmod.entity.DeathShootEntity;
import net.mcreator.epicestmod.init.EpicestModModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class DeathSkullRightclickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        Entity _shootFrom = entity;
        Level projectileLevel = _shootFrom.level();
        if (!projectileLevel.isClientSide()) {
            AbstractArrow _entityToSpawn = DeathSkullRightclickedProcedure.initArrowProjectile(new DeathShootEntity((EntityType<? extends DeathShootEntity>)((EntityType)EpicestModModEntities.DEATH_SHOOT.get()), 0.0, 0.0, 0.0, projectileLevel, DeathSkullRightclickedProcedure.createArrowWeaponItemStack(projectileLevel, 1, (byte)0)), null, 5.0f, true, true, false, AbstractArrow.Pickup.DISALLOWED);
            _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
            _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.5f, 0.0f);
            projectileLevel.addFreshEntity((Entity)_entityToSpawn);
        }
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.isClientSide()) {
                _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wither.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.wither.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
        if (entity instanceof Player) {
            Player _player = (Player)entity;
            _player.getCooldowns().addCooldown(itemstack, 100);
        }
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

