/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelRockGolemb2d
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"epicest_mod", (String)"model_rock_golemb_2d"), "main");
    public final ModelPart bone;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart right_front_leg;
    public final ModelPart right_hind_leg;
    public final ModelPart left_front_leg;
    public final ModelPart left_hind_leg;

    public ModelRockGolemb2d(ModelPart root) {
        super(root);
        this.bone = root.getChild("bone");
        this.body = this.bone.getChild("body");
        this.head = this.body.getChild("head");
        this.right_front_leg = this.bone.getChild("right_front_leg");
        this.right_hind_leg = this.bone.getChild("right_hind_leg");
        this.left_front_leg = this.bone.getChild("left_front_leg");
        this.left_hind_leg = this.bone.getChild("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition body = bone.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-7.5f, -11.0f, -20.0f, 14.0f, 16.0f, 40.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-18.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(-2, 58).addBox(-8.5f, -23.5f, -15.5f, 16.0f, 19.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.5f, (float)-19.4f));
        PartDefinition right_front_leg = bone.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 93).addBox(-8.5f, -24.0f, -4.0f, 8.0f, 33.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition right_hind_leg = bone.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(64, 100).addBox(-8.5f, -13.0f, -4.0f, 8.0f, 22.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.5f, (float)10.0f, (float)15.0f));
        PartDefinition left_front_leg = bone.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(32, 100).addBox(-0.5f, -24.0f, -4.0f, 8.0f, 33.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.5f, (float)10.0f, (float)-15.0f));
        PartDefinition left_hind_leg = bone.addOrReplaceChild("left_hind_leg", CubeListBuilder.create(), PartPose.offset((float)7.5f, (float)10.0f, (float)15.0f));
        PartDefinition left_hind_leg_r1 = left_hind_leg.addOrReplaceChild("left_hind_leg_r1", CubeListBuilder.create().texOffs(96, 100).addBox(-4.0f, -16.9905f, -4.4362f, 8.0f, 23.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)3.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_front_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.right_hind_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_hind_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_front_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

