/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelRoyalKnight
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"epicest_mod", (String)"model_royal_knight"), "main");
    public final ModelPart RightArm;
    public final ModelPart Head;
    public final ModelPart LeftLeg;
    public final ModelPart RightLeg;
    public final ModelPart LeftArm;
    public final ModelPart Body;

    public ModelRoyalKnight(ModelPart root) {
        super(root);
        this.RightArm = root.getChild("RightArm");
        this.Head = root.getChild("Head");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftArm = root.getChild("LeftArm");
        this.Body = root.getChild("Body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(36, 0).addBox(-4.0f, 13.0f, -5.0f, 7.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(40, 45).addBox(-3.0f, 0.0f, -4.0f, 5.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(66, 9).addBox(-4.0f, -3.0f, -4.0f, 7.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.0f, (float)-10.0f, (float)1.0f));
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 26).addBox(-5.0f, -12.0f, -4.0f, 10.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(62, 74).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 69).addBox(-5.0f, -6.0f, -6.0f, 10.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(24, 74).addBox(-5.0f, -14.0f, -6.0f, 10.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 76).addBox(-2.0f, -16.0f, 0.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(26, 47).addBox(-6.0f, -13.0f, -5.0f, 1.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(48, 74).addBox(5.0f, -13.0f, -5.0f, 1.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(66, 18).addBox(-5.0f, -13.0f, 1.0f, 10.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 35).addBox(-5.0f, -14.0f, -4.0f, 10.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(52, 64).addBox(-1.0f, -19.0f, 1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(62, 79).addBox(-2.0f, -22.0f, 1.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(26, 64).addBox(-3.0f, -25.0f, 3.0f, 6.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(78, 79).addBox(-2.0f, -22.0f, 8.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)-1.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(0, 58).addBox(-3.0f, 12.0f, -5.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(62, 42).addBox(-3.0f, -1.0f, -2.0f, 5.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)9.0f, (float)-1.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 47).addBox(-2.0f, 12.0f, -5.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(62, 58).addBox(-2.0f, -1.0f, -2.0f, 5.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)9.0f, (float)-1.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(66, 0).addBox(-3.0f, -3.0f, -4.0f, 7.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(40, 26).addBox(-2.0f, 0.0f, -4.0f, 5.0f, 13.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 13).addBox(-3.0f, 13.0f, -5.0f, 7.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-10.0f, (float)1.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(62, 26).addBox(-1.0f, -21.0f, -5.0f, 12.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -21.0f, -3.0f, 12.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.RightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.LeftLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.Head.yRot = netHeadYaw / 57.295776f;
        this.Head.xRot = headPitch / 57.295776f;
        this.RightLeg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.LeftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

