/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.epicestmod.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import net.mcreator.epicestmod.init.EpicestModModItems;
import net.mcreator.epicestmod.procedures.HolyArmorBootsTickEventProcedure;
import net.mcreator.epicestmod.procedures.HolyArmorChestplateTickEventProcedure;
import net.mcreator.epicestmod.procedures.HolyArmorHelmetTickEventProcedure;
import net.mcreator.epicestmod.procedures.HolyArmorLeggingsTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class HolyArmorItem
extends ArmorItem {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(25, Map.of(ArmorType.BOOTS, 7, ArmorType.LEGGINGS, 10, ArmorType.CHESTPLATE, 14, ArmorType.HELMET, 8, ArmorType.BODY, 14), 15, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY), 4.0f, 0.3f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"epicest_mod:holy_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"epicest_mod:holy_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/holyarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.HOLY_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/holyarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.HOLY_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/holyarmor_layer_2.png");
            }
        }, new Item[]{(Item)EpicestModModItems.HOLY_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"epicest_mod:textures/models/armor/holyarmor_layer_1.png");
            }
        }, new Item[]{(Item)EpicestModModItems.HOLY_ARMOR_BOOTS.get()});
    }

    private HolyArmorItem(ArmorType type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Boots
    extends HolyArmorItem {
        public Boots(Item.Properties properties) {
            super(ArmorType.BOOTS, properties);
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                HolyArmorBootsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Leggings
    extends HolyArmorItem {
        public Leggings(Item.Properties properties) {
            super(ArmorType.LEGGINGS, properties);
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                HolyArmorLeggingsTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Chestplate
    extends HolyArmorItem {
        public Chestplate(Item.Properties properties) {
            super(ArmorType.CHESTPLATE, properties);
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                HolyArmorChestplateTickEventProcedure.execute(entity);
            }
        }
    }

    public static class Helmet
    extends HolyArmorItem {
        public Helmet(Item.Properties properties) {
            super(ArmorType.HELMET, properties);
        }

        public boolean makesPiglinsNeutral(ItemStack itemstack, LivingEntity entity) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                HolyArmorHelmetTickEventProcedure.execute(entity);
            }
        }
    }
}

