// Made with Blockbench 4.12.4
// Exported for Minecraft version 1.17 or later with Mojang mappings
// Paste this class into your mod and generate all required imports

public class ModelNullman<T extends Entity> extends EntityModel<T> {
	// This layer location should be baked with EntityRendererProvider.Context in
	// the entity renderer and passed into this model's constructor
	public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(
			new ResourceLocation("modid", "nullman"), "main");
	private final ModelPart body;
	private final ModelPart head;

	public ModelNullman(ModelPart root) {
		this.body = root.getChild("body");
		this.head = root.getChild("head");
	}

	public static LayerDefinition createBodyLayer() {
		MeshDefinition meshdefinition = new MeshDefinition();
		PartDefinition partdefinition = meshdefinition.getRoot();

		PartDefinition body = partdefinition.addOrReplaceChild("body",
				CubeListBuilder.create().texOffs(0, 0)
						.addBox(-8.0F, -10.0F, -8.0F, 16.0F, 10.0F, 16.0F, new CubeDeformation(0.0F)).texOffs(64, 14)
						.addBox(-6.0F, -12.0F, -7.0F, 0.0F, 2.0F, 14.0F, new CubeDeformation(0.0F)).texOffs(64, 30)
						.addBox(6.0F, -12.0F, -7.0F, 0.0F, 2.0F, 14.0F, new CubeDeformation(0.0F)),
				PartPose.offset(0.0F, 24.0F, 0.0F));

		PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1",
				CubeListBuilder.create().texOffs(56, 64).addBox(6.0F, -2.0F, -6.0F, 0.0F, 2.0F, 12.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(0.0F, -10.0F, -1.0F, 0.0F, 1.5708F, 0.0F));

		PartDefinition head = partdefinition.addOrReplaceChild("head",
				CubeListBuilder.create().texOffs(0, 26)
						.addBox(-8.0F, -6.0F, -9.0F, 16.0F, 6.0F, 16.0F, new CubeDeformation(0.0F)).texOffs(0, 48)
						.addBox(-7.0F, -12.0F, -9.0F, 14.0F, 6.0F, 14.0F, new CubeDeformation(0.0F)).texOffs(56, 48)
						.addBox(-6.0F, -18.0F, -8.0F, 12.0F, 6.0F, 10.0F, new CubeDeformation(0.0F)).texOffs(64, 0)
						.addBox(-5.0F, -24.0F, -8.0F, 10.0F, 6.0F, 8.0F, new CubeDeformation(0.0F)).texOffs(0, 68)
						.addBox(-4.0F, -24.0F, -10.0F, 8.0F, 9.0F, 2.0F, new CubeDeformation(0.0F)),
				PartPose.offset(0.0F, 14.0F, 1.0F));

		return LayerDefinition.create(meshdefinition, 128, 128);
	}

	@Override
	public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay,
			float red, float green, float blue, float alpha) {
		body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
	}

	public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw,
			float headPitch) {
		this.head.yRot = netHeadYaw / (180F / (float) Math.PI);
		this.head.xRot = headPitch / (180F / (float) Math.PI);
	}
}