// Made with Blockbench 4.12.4
// Exported for Minecraft version 1.17 or later with Mojang mappings
// Paste this class into your mod and generate all required imports

public class ModelTheDredge<T extends Entity> extends EntityModel<T> {
	// This layer location should be baked with EntityRendererProvider.Context in
	// the entity renderer and passed into this model's constructor
	public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(
			new ResourceLocation("modid", "thedredge"), "main");
	private final ModelPart rightleg;
	private final ModelPart leftleg;
	private final ModelPart body;
	private final ModelPart head;
	private final ModelPart rightarm;
	private final ModelPart leftarm;

	public ModelTheDredge(ModelPart root) {
		this.rightleg = root.getChild("rightleg");
		this.leftleg = root.getChild("leftleg");
		this.body = root.getChild("body");
		this.head = root.getChild("head");
		this.rightarm = root.getChild("rightarm");
		this.leftarm = root.getChild("leftarm");
	}

	public static LayerDefinition createBodyLayer() {
		MeshDefinition meshdefinition = new MeshDefinition();
		PartDefinition partdefinition = meshdefinition.getRoot();

		PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg",
				CubeListBuilder.create().texOffs(24, 62)
						.addBox(-1.0F, -2.0F, -1.0F, 2.0F, 16.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(0, 43)
						.addBox(-1.0F, 14.0F, -0.6F, 2.0F, 18.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(42, 0)
						.addBox(-1.0F, 31.0F, -4.6F, 2.0F, 1.0F, 4.0F, new CubeDeformation(0.0F)),
				PartPose.offset(-3.0F, -8.0F, 0.0F));

		PartDefinition cube_r1 = rightleg
				.addOrReplaceChild("cube_r1",
						CubeListBuilder.create().texOffs(0, 63).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 16.0F, 2.0F,
								new CubeDeformation(0.0F)),
						PartPose.offsetAndRotation(0.0F, 0.0F, 1.0F, -0.0436F, 0.0F, 0.0F));

		PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg",
				CubeListBuilder.create().texOffs(8, 63)
						.addBox(-1.0F, -2.0F, -1.0F, 2.0F, 16.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(8, 43)
						.addBox(-1.0F, 14.0F, -0.6F, 2.0F, 18.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(42, 5)
						.addBox(-1.0F, 31.0F, -4.6F, 2.0F, 1.0F, 4.0F, new CubeDeformation(0.0F)),
				PartPose.offset(3.0F, -8.0F, 0.0F));

		PartDefinition cube_r2 = leftleg
				.addOrReplaceChild("cube_r2",
						CubeListBuilder.create().texOffs(64, 0).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 16.0F, 2.0F,
								new CubeDeformation(0.0F)),
						PartPose.offsetAndRotation(0.0F, 0.0F, 1.0F, -0.0436F, 0.0F, 0.0F));

		PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(36, 15).addBox(
				-4.0F, -8.0F, -2.0F, 8.0F, 4.0F, 6.0F, new CubeDeformation(0.0F)), PartPose.offset(0.0F, -8.0F, 0.0F));

		PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3",
				CubeListBuilder.create().texOffs(0, 0).addBox(-6.0F, -6.0F, -5.0F, 12.0F, 6.0F, 9.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(0.0F, -12.0F, -1.0F, 0.9599F, 0.0F, 0.0F));

		PartDefinition cube_r4 = body
				.addOrReplaceChild("cube_r4",
						CubeListBuilder.create().texOffs(0, 15).addBox(-5.0F, -6.0F, -4.0F, 10.0F, 6.0F, 8.0F,
								new CubeDeformation(0.0F)),
						PartPose.offsetAndRotation(0.0F, -8.0F, 1.0F, 0.5236F, 0.0F, 0.0F));

		PartDefinition cube_r5 = body
				.addOrReplaceChild("cube_r5",
						CubeListBuilder.create().texOffs(32, 38).addBox(-3.0F, -4.0F, -2.0F, 6.0F, 4.0F, 5.0F,
								new CubeDeformation(0.0F)),
						PartPose.offsetAndRotation(0.0F, 0.0F, 0.0F, -0.1745F, 0.0F, 0.0F));

		PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 29)
				.addBox(-4.0F, -6.0F, -7.0F, 8.0F, 6.0F, 8.0F, new CubeDeformation(0.0F)),
				PartPose.offset(0.0F, -24.0F, -5.0F));

		PartDefinition cube_r6 = head
				.addOrReplaceChild("cube_r6",
						CubeListBuilder.create().texOffs(32, 29).addBox(-4.0F, -1.0F, -7.0F, 8.0F, 1.0F, 8.0F,
								new CubeDeformation(0.0F)),
						PartPose.offsetAndRotation(0.0F, 0.0F, 0.0F, 0.48F, 0.0F, 0.0F));

		PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm",
				CubeListBuilder.create().texOffs(16, 43)
						.addBox(-2.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(32, 47)
						.addBox(-2.0F, 15.0F, -1.0F, 2.0F, 17.0F, 2.0F, new CubeDeformation(0.0F)),
				PartPose.offset(-6.0F, -21.0F, -5.0F));

		PartDefinition cube_r7 = rightarm.addOrReplaceChild("cube_r7",
				CubeListBuilder.create().texOffs(24, 43).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(-1.0F, 0.0F, 1.0F, -0.0873F, 0.0F, 0.0F));

		PartDefinition cube_r8 = rightarm.addOrReplaceChild("cube_r8",
				CubeListBuilder.create().texOffs(40, 47).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(-1.0F, 17.0F, -1.0F, 0.0436F, 0.0F, 0.0F));

		PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm",
				CubeListBuilder.create().texOffs(48, 47)
						.addBox(-2.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F, new CubeDeformation(0.0F)).texOffs(56, 38)
						.addBox(-2.0F, 15.0F, -1.0F, 2.0F, 17.0F, 2.0F, new CubeDeformation(0.0F)),
				PartPose.offset(8.0F, -21.0F, -5.0F));

		PartDefinition cube_r9 = leftarm.addOrReplaceChild("cube_r9",
				CubeListBuilder.create().texOffs(16, 62).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(-1.0F, 0.0F, 1.0F, -0.0873F, 0.0F, 0.0F));

		PartDefinition cube_r10 = leftarm.addOrReplaceChild("cube_r10",
				CubeListBuilder.create().texOffs(56, 57).addBox(-1.0F, -2.0F, -1.0F, 2.0F, 17.0F, 2.0F,
						new CubeDeformation(0.0F)),
				PartPose.offsetAndRotation(-1.0F, 17.0F, -1.0F, 0.0436F, 0.0F, 0.0F));

		return LayerDefinition.create(meshdefinition, 128, 128);
	}

	@Override
	public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay,
			float red, float green, float blue, float alpha) {
		rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
		leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
	}

	public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw,
			float headPitch) {
		this.head.yRot = netHeadYaw / (180F / (float) Math.PI);
		this.head.xRot = headPitch / (180F / (float) Math.PI);
		this.rightleg.xRot = Mth.cos(limbSwing * 1.0F) * -1.0F * limbSwingAmount;
		this.leftleg.xRot = Mth.cos(limbSwing * 1.0F) * 1.0F * limbSwingAmount;
		this.leftarm.xRot = Mth.cos(limbSwing * 1.0F) * -1.0F * limbSwingAmount;
	}
}