
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.fromthehillsidegates.init;

import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;

import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity;
import net.minecraft.core.registries.Registries;

import net.mcreator.fromthehillsidegates.entity.WhistlerEntity;
import net.mcreator.fromthehillsidegates.entity.TheMinerEntity;
import net.mcreator.fromthehillsidegates.entity.TheGraveDiggerEntity;
import net.mcreator.fromthehillsidegates.entity.TheDredgeEntity;
import net.mcreator.fromthehillsidegates.entity.StalkerEntity;
import net.mcreator.fromthehillsidegates.entity.ParasiteEntity;
import net.mcreator.fromthehillsidegates.entity.NullmanEntity;
import net.mcreator.fromthehillsidegates.FromTheHillsideGatesMod;

@EventBusSubscriber(bus = EventBusSubscriber.Bus.MOD)
public class FromTheHillsideGatesModEntities {
	public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create(Registries.ENTITY_TYPE, FromTheHillsideGatesMod.MODID);
	public static final DeferredHolder<EntityType<?>, EntityType<TheGraveDiggerEntity>> THE_GRAVE_DIGGER = register("the_grave_digger",
			EntityType.Builder.<TheGraveDiggerEntity>of(TheGraveDiggerEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(2000).setUpdateInterval(3)

					.sized(1.4f, 2.4f));
	public static final DeferredHolder<EntityType<?>, EntityType<StalkerEntity>> STALKER = register("stalker",
			EntityType.Builder.<StalkerEntity>of(StalkerEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

					.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<TheDredgeEntity>> THE_DREDGE = register("the_dredge",
			EntityType.Builder.<TheDredgeEntity>of(TheDredgeEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(25).setUpdateInterval(3)

					.sized(0.6f, 3f));
	public static final DeferredHolder<EntityType<?>, EntityType<NullmanEntity>> NULLMAN = register("nullman",
			EntityType.Builder.<NullmanEntity>of(NullmanEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

					.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<ParasiteEntity>> PARASITE = register("parasite",
			EntityType.Builder.<ParasiteEntity>of(ParasiteEntity::new, MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

					.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<TheMinerEntity>> THE_MINER = register("the_miner",
			EntityType.Builder.<TheMinerEntity>of(TheMinerEntity::new, MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

					.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<WhistlerEntity>> WHISTLER = register("whistler",
			EntityType.Builder.<WhistlerEntity>of(WhistlerEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(2000).setUpdateInterval(3)

					.sized(0.6f, 2.4f));

	private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
		return REGISTRY.register(registryname, () -> (EntityType<T>) entityTypeBuilder.build(registryname));
	}

	@SubscribeEvent
	public static void init(SpawnPlacementRegisterEvent event) {
		TheGraveDiggerEntity.init(event);
		StalkerEntity.init(event);
		TheDredgeEntity.init(event);
		NullmanEntity.init(event);
		ParasiteEntity.init(event);
		TheMinerEntity.init(event);
		WhistlerEntity.init(event);
	}

	@SubscribeEvent
	public static void registerAttributes(EntityAttributeCreationEvent event) {
		event.put(THE_GRAVE_DIGGER.get(), TheGraveDiggerEntity.createAttributes().build());
		event.put(STALKER.get(), StalkerEntity.createAttributes().build());
		event.put(THE_DREDGE.get(), TheDredgeEntity.createAttributes().build());
		event.put(NULLMAN.get(), NullmanEntity.createAttributes().build());
		event.put(PARASITE.get(), ParasiteEntity.createAttributes().build());
		event.put(THE_MINER.get(), TheMinerEntity.createAttributes().build());
		event.put(WHISTLER.get(), WhistlerEntity.createAttributes().build());
	}
}
