/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.shpuksmobs.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelCustomModel
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"shpuks_mobs", (String)"model_custom_model"), "main");
    public final ModelPart legright;
    public final ModelPart legleft;
    public final ModelPart body;
    public final ModelPart lrftarm;
    public final ModelPart rightarm;
    public final ModelPart head;

    public ModelCustomModel(ModelPart root) {
        super(root);
        this.legright = root.getChild("legright");
        this.legleft = root.getChild("legleft");
        this.body = root.getChild("body");
        this.lrftarm = root.getChild("lrftarm");
        this.rightarm = root.getChild("rightarm");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legright = partdefinition.addOrReplaceChild("legright", CubeListBuilder.create().texOffs(28, 26).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)14.0f, (float)0.0f));
        PartDefinition legleft = partdefinition.addOrReplaceChild("legleft", CubeListBuilder.create().texOffs(0, 36).addBox(2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)14.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -18.0f, -2.0f, 8.0f, 18.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition lrftarm = partdefinition.addOrReplaceChild("lrftarm", CubeListBuilder.create().texOffs(28, 0).addBox(8.0f, 0.0f, -1.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = rightarm.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(36, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 19.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 22).addBox(-3.0f, -7.0f, 1.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(45, 2).addBox(-2.0f, -2.0f, 1.0f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.legright.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.lrftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.rightarm.xRot = ageInTicks;
        this.legleft.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

