
/*
 *    MCreator note: This file will be REGENERATED on each build.
 */
package net.mcreator.thebrokenscriptlite.init;

import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;

import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.resources.ResourceKey;
import net.minecraft.core.registries.Registries;

import net.mcreator.thebrokenscriptlite.entity.XXRAMTODIEXXEntity;
import net.mcreator.thebrokenscriptlite.entity.R2Entity;
import net.mcreator.thebrokenscriptlite.entity.NulllEntity;
import net.mcreator.thebrokenscriptlite.entity.NothingiswatchingEntity;
import net.mcreator.thebrokenscriptlite.entity.IntegrityEntity;
import net.mcreator.thebrokenscriptlite.entity.HimEntity;
import net.mcreator.thebrokenscriptlite.TheBrokenScriptLiteMod;

@EventBusSubscriber(bus = EventBusSubscriber.Bus.MOD)
public class TheBrokenScriptLiteModEntities {
	public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create(Registries.ENTITY_TYPE, TheBrokenScriptLiteMod.MODID);
	public static final DeferredHolder<EntityType<?>, EntityType<R2Entity>> R_2 = register("r_2", EntityType.Builder.<R2Entity>of(R2Entity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

			.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<NulllEntity>> NULLL = register("nulll",
			EntityType.Builder.<NulllEntity>of(NulllEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<XXRAMTODIEXXEntity>> XXRAMTODIEXX = register("xxramtodiexx",
			EntityType.Builder.<XXRAMTODIEXXEntity>of(XXRAMTODIEXXEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<HimEntity>> HIM = register("him", EntityType.Builder.<HimEntity>of(HimEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

			.sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<IntegrityEntity>> INTEGRITY = register("integrity",
			EntityType.Builder.<IntegrityEntity>of(IntegrityEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
	public static final DeferredHolder<EntityType<?>, EntityType<NothingiswatchingEntity>> NOTHINGISWATCHING = register("nothingiswatching",
			EntityType.Builder.<NothingiswatchingEntity>of(NothingiswatchingEntity::new, MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3)

					.sized(0.6f, 1.8f));

	// Start of user code block custom entities
	// End of user code block custom entities
	private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
		return REGISTRY.register(registryname, () -> (EntityType<T>) entityTypeBuilder.build(ResourceKey.create(Registries.ENTITY_TYPE, ResourceLocation.fromNamespaceAndPath(TheBrokenScriptLiteMod.MODID, registryname))));
	}

	@SubscribeEvent
	public static void init(RegisterSpawnPlacementsEvent event) {
		R2Entity.init(event);
		NulllEntity.init(event);
		XXRAMTODIEXXEntity.init(event);
		HimEntity.init(event);
		IntegrityEntity.init(event);
		NothingiswatchingEntity.init(event);
	}

	@SubscribeEvent
	public static void registerAttributes(EntityAttributeCreationEvent event) {
		event.put(R_2.get(), R2Entity.createAttributes().build());
		event.put(NULLL.get(), NulllEntity.createAttributes().build());
		event.put(XXRAMTODIEXX.get(), XXRAMTODIEXXEntity.createAttributes().build());
		event.put(HIM.get(), HimEntity.createAttributes().build());
		event.put(INTEGRITY.get(), IntegrityEntity.createAttributes().build());
		event.put(NOTHINGISWATCHING.get(), NothingiswatchingEntity.createAttributes().build());
	}
}
