
package net.mcreator.nightofthesilverfish.potion;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.particles.SimpleParticleType;

import net.mcreator.nightofthesilverfish.procedures.CriticallyInfestedOnEntityHurtProcedure;
import net.mcreator.nightofthesilverfish.init.NightOfTheSilverfishModParticleTypes;

public class CriticallyInfestedMobEffect extends MobEffect {
	public CriticallyInfestedMobEffect() {
		super(MobEffectCategory.HARMFUL, -13421773, mobEffectInstance -> (SimpleParticleType) (NightOfTheSilverfishModParticleTypes.CRITICALLY_INFESTEDPARTICALS.get()));
		this.withSoundOnAdded(BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse("entity.silverfish.ambient")));
	}

	@Override
	public void onMobHurt(ServerLevel level, LivingEntity entity, int amplifier, DamageSource damagesource, float damage) {
		CriticallyInfestedOnEntityHurtProcedure.execute(level, entity.getX(), entity.getY(), entity.getZ());
	}
}
