/*
 * Decompiled with CFR 0.152.
 */
package combat_dash.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import combat_dash.configuration.CombatDashClientConfiguration;
import combat_dash.network.CombatDashModVariables;
import combat_dash.procedures.DashWhenoffhandisnothingProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DashOverlayOverlay {
    private static long fullyFilledTime = -1L;
    private static float alpha = 1.0f;
    private static final long FADE_START_DELAY = 1500L;
    private static final long FADE_DURATION = 1000L;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null) {
            DashOverlayOverlay.renderDashBars(event, (Player)entity, w, h);
        }
    }

    private static void renderDashBars(RenderGuiEvent.Pre event, Player entity, int screenWidth, int screenHeight) {
        boolean isDashEnabled;
        boolean isDashOffhandBlocked = !DashWhenoffhandisnothingProcedure.execute((Entity)entity);
        boolean bl = isDashEnabled = entity.m_21051_((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("combat_dash:enabledash"))) != null && entity.m_21051_((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("combat_dash:enabledash"))).m_22135_() == 1.0;
        if (isDashOffhandBlocked || !isDashEnabled) {
            return;
        }
        double DASHCONFIGXZPOS = (Double)CombatDashClientConfiguration.DASHCONFIGXZPOS.get() + 8.0;
        double DASHCONFIGYPOS = (Double)CombatDashClientConfiguration.DASHCONFIGYPOS.get();
        int numberOfBars = entity.m_21051_((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("combat_dash:max_dash_amount"))) != null ? (int)entity.m_21051_((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("combat_dash:max_dash_amount"))).m_22135_() : 3;
        double dashCooldown = entity.getCapability(CombatDashModVariables.PLAYER_VARIABLES_CAPABILITY, null).map(capability -> capability.DashCooldown).orElse(0.0);
        double dashCooldownMax = entity.m_21051_((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("combat_dash:dash_cool_down"))).m_22115_() * (double)numberOfBars;
        boolean allFull = true;
        for (int i = 0; i < numberOfBars; ++i) {
            double fillPercentage = Math.max(0.0, Math.min(1.0, (dashCooldown - (double)i * (dashCooldownMax / (double)numberOfBars)) / (dashCooldownMax / (double)numberOfBars)));
            if (!(fillPercentage < 1.0)) continue;
            allFull = false;
            break;
        }
        long currentTime = System.currentTimeMillis();
        if (allFull) {
            if (fullyFilledTime == -1L) {
                fullyFilledTime = currentTime;
            } else if (currentTime - fullyFilledTime >= 1500L) {
                float elapsedFadeTime = currentTime - fullyFilledTime - 1500L;
                alpha = Math.max(0.0f, 1.0f - elapsedFadeTime / 1000.0f);
            }
        } else {
            fullyFilledTime = -1L;
            alpha = 1.0f;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        for (int i = 0; i < numberOfBars; ++i) {
            int xOffset = (int)DASHCONFIGXZPOS - i * 5;
            int yOffset = (int)DASHCONFIGYPOS;
            event.getGuiGraphics().m_280163_(new ResourceLocation("combat_dash:textures/screens/arrowback.png"), screenWidth / 2 + xOffset - 1, screenHeight - yOffset - 1, 0.0f, 0.0f, 11, 13, 11, 13);
            double fillPercentage = Math.max(0.0, Math.min(1.0, (dashCooldown - (double)i * (dashCooldownMax / (double)numberOfBars)) / (dashCooldownMax / (double)numberOfBars)));
            int barHeight = (int)(11.0 * (1.0 - fillPercentage));
            event.getGuiGraphics().m_280163_(new ResourceLocation("combat_dash:textures/screens/arrow_1401.png"), screenWidth / 2 + xOffset, screenHeight - yOffset, 0.0f, 0.0f, 9, barHeight, 9, 11);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }
}

