/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.heriosfloralexpansion.entity;

import net.mcreator.heriosfloralexpansion.init.HeriosFloralExpansionModEntities;
import net.mcreator.heriosfloralexpansion.procedures.BabyScaleProcedure;
import net.mcreator.heriosfloralexpansion.procedures.DryBloomEntityIsHurtProcedure;
import net.mcreator.heriosfloralexpansion.procedures.IdlePlaybackConditionProcedure;
import net.mcreator.heriosfloralexpansion.procedures.WalkingPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DryBloomEntity
extends PathfinderMob {
    public static final EntityDataAccessor<Boolean> DATA_bloom_blue = SynchedEntityData.defineId(DryBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_bloom_red = SynchedEntityData.defineId(DryBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_bloom_pink = SynchedEntityData.defineId(DryBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_bloom_yellow = SynchedEntityData.defineId(DryBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_bloom_white = SynchedEntityData.defineId(DryBloomEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public DryBloomEntity(EntityType<DryBloomEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_bloom_blue, (Object)false);
        builder.define(DATA_bloom_red, (Object)false);
        builder.define(DATA_bloom_pink, (Object)false);
        builder.define(DATA_bloom_yellow, (Object)false);
        builder.define(DATA_bloom_white, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(new ItemStack((ItemLike)Items.STICK));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        DryBloomEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        DryBloomEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)entity);
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Databloom_blue", ((Boolean)this.entityData.get(DATA_bloom_blue)).booleanValue());
        compound.putBoolean("Databloom_red", ((Boolean)this.entityData.get(DATA_bloom_red)).booleanValue());
        compound.putBoolean("Databloom_pink", ((Boolean)this.entityData.get(DATA_bloom_pink)).booleanValue());
        compound.putBoolean("Databloom_yellow", ((Boolean)this.entityData.get(DATA_bloom_yellow)).booleanValue());
        compound.putBoolean("Databloom_white", ((Boolean)this.entityData.get(DATA_bloom_white)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Databloom_blue")) {
            this.entityData.set(DATA_bloom_blue, (Object)compound.getBoolean("Databloom_blue"));
        }
        if (compound.contains("Databloom_red")) {
            this.entityData.set(DATA_bloom_red, (Object)compound.getBoolean("Databloom_red"));
        }
        if (compound.contains("Databloom_pink")) {
            this.entityData.set(DATA_bloom_pink, (Object)compound.getBoolean("Databloom_pink"));
        }
        if (compound.contains("Databloom_yellow")) {
            this.entityData.set(DATA_bloom_yellow, (Object)compound.getBoolean("Databloom_yellow"));
        }
        if (compound.contains("Databloom_white")) {
            this.entityData.set(DATA_bloom_white, (Object)compound.getBoolean("Databloom_white"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdlePlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(WalkingPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        DryBloomEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)BabyScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)HeriosFloralExpansionModEntities.DRY_BLOOM.get(), SpawnPlacementTypes.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

