/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minions.entity;

import net.mcreator.minions.init.MinionsModItems;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class CaveMinionEntityProjectile
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)MinionsModItems.ROCK_ITEM.get());

    public CaveMinionEntityProjectile(EntityType<? extends CaveMinionEntityProjectile> type, Level world) {
        super(type, world);
    }

    public CaveMinionEntityProjectile(EntityType<? extends CaveMinionEntityProjectile> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world, PROJECTILE_ITEM, null);
    }

    public CaveMinionEntityProjectile(EntityType<? extends CaveMinionEntityProjectile> type, LivingEntity entity, Level world) {
        super(type, entity, world, PROJECTILE_ITEM, null);
    }

    protected void doPostHurtEffects(LivingEntity livingEntity) {
        super.doPostHurtEffects(livingEntity);
        livingEntity.setArrowCount(livingEntity.getArrowCount() - 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)MinionsModItems.ROCK_ITEM.get());
    }
}

