/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minions.entity;

import javax.annotation.Nullable;
import net.mcreator.minions.init.MinionsModEntities;
import net.mcreator.minions.init.MinionsModItems;
import net.mcreator.minions.procedures.RockProjectileHitsBlockProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class RockEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)MinionsModItems.ROCK_ITEM.get());
    private int knockback = 0;

    public RockEntity(EntityType<? extends RockEntity> type, Level world) {
        super(type, world);
    }

    public RockEntity(EntityType<? extends RockEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    public RockEntity(EntityType<? extends RockEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)MinionsModItems.ROCK_ITEM.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 projectilePosition, Vec3 deltaPosition) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        AABB lookupBox = this.getBoundingBox().expandTowards(deltaPosition).inflate(1.0);
        for (Entity entity1 : this.level().getEntities((Entity)this, lookupBox, x$0 -> this.canHitEntity((Entity)x$0))) {
            double d1;
            AABB aabb;
            if (entity1 == this.getOwner() || !(aabb = entity1.getBoundingBox()).intersects(lookupBox) || !((d1 = projectilePosition.distanceToSqr(projectilePosition)) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    public void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        RockProjectileHitsBlockProcedure.execute(this.getOwner());
    }

    public void tick() {
        super.tick();
        if (this.inGround) {
            this.discard();
        }
    }

    public static RockEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return RockEntity.shoot(world, entity, source, 0.6f, 3.0, 0);
    }

    public static RockEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return RockEntity.shoot(world, entity, source, pullingPower * 0.6f, 3.0, 0);
    }

    public static RockEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        RockEntity entityarrow = new RockEntity((EntityType<? extends RockEntity>)((EntityType)MinionsModEntities.ROCK.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.dripstone_block.break")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static RockEntity shoot(LivingEntity entity, LivingEntity target) {
        RockEntity entityarrow = new RockEntity((EntityType<? extends RockEntity>)((EntityType)MinionsModEntities.ROCK.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 1.2f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(3.0);
        entityarrow.setKnockback(0);
        entityarrow.setCritArrow(true);
        entity.level().addFreshEntity((Entity)entityarrow);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.dripstone_block.break")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.create().nextFloat() * 0.5f + 1.0f));
        return entityarrow;
    }
}

