/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minions.init;

import net.mcreator.minions.entity.BorealMinionEntity;
import net.mcreator.minions.entity.CaveMinionEntity;
import net.mcreator.minions.entity.CaveMinionEntityProjectile;
import net.mcreator.minions.entity.EndMinionEntity;
import net.mcreator.minions.entity.MinionEntity;
import net.mcreator.minions.entity.NetherMinionEntity;
import net.mcreator.minions.entity.RockEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class MinionsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"minions");
    public static final DeferredHolder<EntityType<?>, EntityType<MinionEntity>> MINION = MinionsModEntities.register("minion", EntityType.Builder.of(MinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1000).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<NetherMinionEntity>> NETHER_MINION = MinionsModEntities.register("nether_minion", EntityType.Builder.of(NetherMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1000).setUpdateInterval(3).fireImmune().sized(0.6f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<EndMinionEntity>> END_MINION = MinionsModEntities.register("end_minion", EntityType.Builder.of(EndMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1000).setUpdateInterval(3).sized(0.6f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CaveMinionEntity>> CAVE_MINION = MinionsModEntities.register("cave_minion", EntityType.Builder.of(CaveMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1000).setUpdateInterval(3).sized(0.6f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CaveMinionEntityProjectile>> CAVE_MINION_PROJECTILE = MinionsModEntities.register("projectile_cave_minion", EntityType.Builder.of(CaveMinionEntityProjectile::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<RockEntity>> ROCK = MinionsModEntities.register("rock", EntityType.Builder.of(RockEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<BorealMinionEntity>> BOREAL_MINION = MinionsModEntities.register("boreal_minion", EntityType.Builder.of(BorealMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(1000).setUpdateInterval(3).sized(0.6f, 1.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MinionEntity.init(event);
        NetherMinionEntity.init(event);
        EndMinionEntity.init(event);
        CaveMinionEntity.init(event);
        BorealMinionEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MINION.get(), MinionEntity.createAttributes().build());
        event.put((EntityType)NETHER_MINION.get(), NetherMinionEntity.createAttributes().build());
        event.put((EntityType)END_MINION.get(), EndMinionEntity.createAttributes().build());
        event.put((EntityType)CAVE_MINION.get(), CaveMinionEntity.createAttributes().build());
        event.put((EntityType)BOREAL_MINION.get(), BorealMinionEntity.createAttributes().build());
    }
}

