/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theotherside.fluid;

import net.mcreator.theotherside.init.TheOthersideModBlocks;
import net.mcreator.theotherside.init.TheOthersideModFluidTypes;
import net.mcreator.theotherside.init.TheOthersideModFluids;
import net.mcreator.theotherside.init.TheOthersideModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class BloodFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)TheOthersideModFluidTypes.BLOOD_TYPE.get(), () -> (Fluid)TheOthersideModFluids.BLOOD.get(), () -> (Fluid)TheOthersideModFluids.FLOWING_BLOOD.get()).explosionResistance(100.0f).tickRate(15).levelDecreasePerBlock(2).bucket(() -> (Item)TheOthersideModItems.BLOOD_BUCKET.get()).block(() -> (LiquidBlock)TheOthersideModBlocks.BLOOD.get());

    private BloodFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends BloodFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends BloodFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

