/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theotherside.init;

import net.mcreator.theotherside.entity.EchovoidEntity;
import net.mcreator.theotherside.entity.GhostEntity;
import net.mcreator.theotherside.entity.GrimSentinelEntity;
import net.mcreator.theotherside.entity.LivingCorpseEntity;
import net.mcreator.theotherside.entity.WandererEntity;
import net.mcreator.theotherside.entity.WatcherEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheOthersideModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"the_otherside");
    public static final DeferredHolder<EntityType<?>, EntityType<WatcherEntity>> WATCHER = TheOthersideModEntities.register("watcher", EntityType.Builder.of(WatcherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<WandererEntity>> WANDERER = TheOthersideModEntities.register("wanderer", EntityType.Builder.of(WandererEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.7f, 4.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<LivingCorpseEntity>> LIVING_CORPSE = TheOthersideModEntities.register("living_corpse", EntityType.Builder.of(LivingCorpseEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<EchovoidEntity>> ECHOVOID = TheOthersideModEntities.register("echovoid", EntityType.Builder.of(EchovoidEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<GhostEntity>> GHOST = TheOthersideModEntities.register("ghost", EntityType.Builder.of(GhostEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<GrimSentinelEntity>> GRIM_SENTINEL = TheOthersideModEntities.register("grim_sentinel", EntityType.Builder.of(GrimSentinelEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.7f, 1.6f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        WatcherEntity.init(event);
        WandererEntity.init(event);
        LivingCorpseEntity.init(event);
        EchovoidEntity.init(event);
        GhostEntity.init(event);
        GrimSentinelEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WATCHER.get(), WatcherEntity.createAttributes().build());
        event.put((EntityType)WANDERER.get(), WandererEntity.createAttributes().build());
        event.put((EntityType)LIVING_CORPSE.get(), LivingCorpseEntity.createAttributes().build());
        event.put((EntityType)ECHOVOID.get(), EchovoidEntity.createAttributes().build());
        event.put((EntityType)GHOST.get(), GhostEntity.createAttributes().build());
        event.put((EntityType)GRIM_SENTINEL.get(), GrimSentinelEntity.createAttributes().build());
    }
}

