/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.theotherside.init;

import net.mcreator.theotherside.potion.GhostTouchMobEffect;
import net.mcreator.theotherside.potion.MalfunctionMobEffect;
import net.mcreator.theotherside.potion.SoulReleaseMobEffect;
import net.mcreator.theotherside.procedures.GhostTouchEffectExpiresProcedure;
import net.mcreator.theotherside.procedures.MalfunctionEffectExpiresProcedure;
import net.mcreator.theotherside.procedures.SoulReleaseEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TheOthersideModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_otherside");
    public static final DeferredHolder<MobEffect, MobEffect> MALFUNCTION = REGISTRY.register("malfunction", () -> new MalfunctionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GHOST_TOUCH = REGISTRY.register("ghost_touch", () -> new GhostTouchMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SOUL_RELEASE = REGISTRY.register("soul_release", () -> new SoulReleaseMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheOthersideModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheOthersideModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(MALFUNCTION)) {
            MalfunctionEffectExpiresProcedure.execute();
        } else if (effectInstance.getEffect().is(GHOST_TOUCH)) {
            GhostTouchEffectExpiresProcedure.execute();
        } else if (effectInstance.getEffect().is(SOUL_RELEASE)) {
            SoulReleaseEffectExpiresProcedure.execute(entity);
        }
    }
}

