/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.catsstuff.init;

import net.mcreator.catsstuff.entity.CatbossEntity;
import net.mcreator.catsstuff.entity.StormtabbyEntity;
import net.mcreator.catsstuff.entity.TabbieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CatsStuffModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cats_stuff");
    public static final DeferredHolder<EntityType<?>, EntityType<CatbossEntity>> CATBOSS = CatsStuffModEntities.register("catboss", EntityType.Builder.of(CatbossEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<StormtabbyEntity>> STORMTABBY = CatsStuffModEntities.register("stormtabby", EntityType.Builder.of(StormtabbyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).setUpdateInterval(3).fireImmune().sized(1.0f, 2.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<TabbieEntity>> TABBIE = CatsStuffModEntities.register("tabbie", EntityType.Builder.of(TabbieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).setUpdateInterval(3).sized(1.0f, 2.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cats_stuff", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        CatbossEntity.init(event);
        StormtabbyEntity.init(event);
        TabbieEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CATBOSS.get(), CatbossEntity.createAttributes().build());
        event.put((EntityType)STORMTABBY.get(), StormtabbyEntity.createAttributes().build());
        event.put((EntityType)TABBIE.get(), TabbieEntity.createAttributes().build());
    }
}

