/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.testmod.fluid;

import net.mcreator.testmod.init.TestModModBlocks;
import net.mcreator.testmod.init.TestModModFluidTypes;
import net.mcreator.testmod.init.TestModModFluids;
import net.mcreator.testmod.init.TestModModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class HeavenlyWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)TestModModFluidTypes.HEAVENLY_WATER_TYPE.get(), () -> (Fluid)TestModModFluids.HEAVENLY_WATER.get(), () -> (Fluid)TestModModFluids.FLOWING_HEAVENLY_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)TestModModItems.HEAVENLY_WATER_BUCKET.get()).block(() -> (LiquidBlock)TestModModBlocks.HEAVENLY_WATER.get());

    private HeavenlyWaterFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends HeavenlyWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends HeavenlyWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

