/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.entity;

import javax.annotation.Nullable;
import net.mcreator.deepborn.entity.DwellerEntity;
import net.mcreator.deepborn.init.DeepbornModEntities;
import net.mcreator.deepborn.procedures.OreGolemAggroProcedure;
import net.mcreator.deepborn.procedures.OreGolemDeathProcedure;
import net.mcreator.deepborn.procedures.OreGolemOnSpawnShenanigansProcedure;
import net.mcreator.deepborn.procedures.OreGolemSpawningProcedure;
import net.mcreator.deepborn.procedures.OregolemAttackingProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class OreGolemEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_Deepslate = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> DATA_ore = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_attacking = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_building = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Grimcrag = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Netherrack = SynchedEntityData.defineId(OreGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public OreGolemEntity(EntityType<OreGolemEntity> type, Level world) {
        super(type, world);
        this.xpReward = 10;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Deepslate, (Object)false);
        builder.define(DATA_ore, (Object)"");
        builder.define(DATA_attacking, (Object)false);
        builder.define(DATA_building, (Object)false);
        builder.define(DATA_Grimcrag, (Object)false);
        builder.define(DATA_Netherrack, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.84 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, OreGolemEntity.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, IronGolem.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, SnowGolem.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, DwellerEntity.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:oregolem_ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:oregolem_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:oregolem_death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        OreGolemDeathProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        OreGolemOnSpawnShenanigansProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataDeepslate", ((Boolean)this.entityData.get(DATA_Deepslate)).booleanValue());
        compound.putString("Dataore", (String)this.entityData.get(DATA_ore));
        compound.putBoolean("Dataattacking", ((Boolean)this.entityData.get(DATA_attacking)).booleanValue());
        compound.putBoolean("Databuilding", ((Boolean)this.entityData.get(DATA_building)).booleanValue());
        compound.putBoolean("DataGrimcrag", ((Boolean)this.entityData.get(DATA_Grimcrag)).booleanValue());
        compound.putBoolean("DataNetherrack", ((Boolean)this.entityData.get(DATA_Netherrack)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataDeepslate")) {
            this.entityData.set(DATA_Deepslate, (Object)compound.getBoolean("DataDeepslate"));
        }
        if (compound.contains("Dataore")) {
            this.entityData.set(DATA_ore, (Object)compound.getString("Dataore"));
        }
        if (compound.contains("Dataattacking")) {
            this.entityData.set(DATA_attacking, (Object)compound.getBoolean("Dataattacking"));
        }
        if (compound.contains("Databuilding")) {
            this.entityData.set(DATA_building, (Object)compound.getBoolean("Databuilding"));
        }
        if (compound.contains("DataGrimcrag")) {
            this.entityData.set(DATA_Grimcrag, (Object)compound.getBoolean("DataGrimcrag"));
        }
        if (compound.contains("DataNetherrack")) {
            this.entityData.set(DATA_Netherrack, (Object)compound.getBoolean("DataNetherrack"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState2.animateWhen(OreGolemAggroProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(OregolemAttackingProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OreGolemEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        OreGolemEntity entity = this;
        return false;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DeepbornModEntities.ORE_GOLEM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return OreGolemSpawningProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 60.0);
        builder = builder.add(Attributes.ARMOR, 4.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 8.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 20.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 1.2);
        return builder;
    }
}

