/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.block;

import net.mcreator.deepborn.procedures.BlacknessSpreadProcedure;
import net.mcreator.deepborn.procedures.BlacknessTransportManualProcedure;
import net.mcreator.deepborn.procedures.BlacknessTransportProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.phys.BlockHitResult;

public class BlacknessBlock
extends Block {
    public BlacknessBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.EMPTY).strength(-1.0f, 3600000.0f).jumpFactor(1.1f).randomTicks().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).instrument(NoteBlockInstrument.BIT));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(blockstate, world, pos, random);
        BlacknessSpreadProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        BlacknessTransportProcedure.execute(entity);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        BlacknessTransportManualProcedure.execute((Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

