/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class ModelStoneGolem
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"deepborn", (String)"model_stone_golem"), "main");
    public final ModelPart legr;
    public final ModelPart legl;
    public final ModelPart upperbody;
    public final ModelPart head;
    public final ModelPart arml;
    public final ModelPart armr;

    public ModelStoneGolem(ModelPart root) {
        super(root);
        this.legr = root.getChild("legr");
        this.legl = root.getChild("legl");
        this.upperbody = root.getChild("upperbody");
        this.head = this.upperbody.getChild("head");
        this.arml = this.upperbody.getChild("arml");
        this.armr = this.upperbody.getChild("armr");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition legr = partdefinition.addOrReplaceChild("legr", CubeListBuilder.create().texOffs(44, 33).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)7.0f, (float)0.0f));
        PartDefinition legl = partdefinition.addOrReplaceChild("legl", CubeListBuilder.create().texOffs(0, 57).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)7.0f, (float)0.0f));
        PartDefinition upperbody = partdefinition.addOrReplaceChild("upperbody", CubeListBuilder.create().texOffs(44, 21).addBox(-7.0f, -6.5f, -2.75f, 14.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-8.0f, -18.5f, -4.75f, 16.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)-0.25f));
        PartDefinition head = upperbody.addOrReplaceChild("head", CubeListBuilder.create().texOffs(50, 0).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-14.5f, (float)-4.75f));
        PartDefinition arml = upperbody.addOrReplaceChild("arml", CubeListBuilder.create().texOffs(22, 21).addBox(-2.5f, -3.0f, -3.0f, 5.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.5f, (float)-14.5f, (float)0.25f));
        PartDefinition armr = upperbody.addOrReplaceChild("armr", CubeListBuilder.create().texOffs(0, 21).addBox(-2.5f, -3.0f, -3.0f, 5.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-10.5f, (float)-14.5f, (float)0.25f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

