/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.fluid;

import net.mcreator.deepborn.init.DeepbornModBlocks;
import net.mcreator.deepborn.init.DeepbornModFluidTypes;
import net.mcreator.deepborn.init.DeepbornModFluids;
import net.mcreator.deepborn.init.DeepbornModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class IchorFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)DeepbornModFluidTypes.ICHOR_TYPE.get(), () -> (Fluid)DeepbornModFluids.ICHOR.get(), () -> (Fluid)DeepbornModFluids.FLOWING_ICHOR.get()).explosionResistance(180.0f).tickRate(15).levelDecreasePerBlock(2).bucket(() -> (Item)DeepbornModItems.ICHOR_BUCKET.get()).block(() -> (LiquidBlock)DeepbornModBlocks.ICHOR.get());

    private IchorFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends IchorFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends IchorFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

