/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.deepborn.client.model.ModelKarkhorra;
import net.mcreator.deepborn.client.model.animations.KarkhorraAnimation;
import net.mcreator.deepborn.entity.KarkhorraEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class KarkhorraRenderer
extends MobRenderer<KarkhorraEntity, LivingEntityRenderState, ModelKarkhorra> {
    private KarkhorraEntity entity = null;

    public KarkhorraRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelKarkhorra.LAYER_LOCATION)), 4.0f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelKarkhorra>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"deepborn:textures/entities/karkhorra_eyes.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelKarkhorra)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(KarkhorraEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"deepborn:textures/entities/karkhorra.png");
    }

    private static final class AnimatedModel
    extends ModelKarkhorra {
        private KarkhorraEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(KarkhorraEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animateWalk(KarkhorraAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.animate(this.entity.animationState1, KarkhorraAnimation.attack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

