/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.deepborn.client.model.ModelWinterwatcher;
import net.mcreator.deepborn.client.model.animations.WinterwatcherAnimation;
import net.mcreator.deepborn.entity.WinterwatcherEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class WinterwatcherRenderer
extends MobRenderer<WinterwatcherEntity, LivingEntityRenderState, ModelWinterwatcher> {
    private WinterwatcherEntity entity = null;

    public WinterwatcherRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelWinterwatcher.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, ModelWinterwatcher>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"deepborn:textures/entities/wiwa_eyes.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                ((ModelWinterwatcher)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(WinterwatcherEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"deepborn:textures/entities/wiwa.png");
    }

    private static final class AnimatedModel
    extends ModelWinterwatcher {
        private WinterwatcherEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(WinterwatcherEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, WinterwatcherAnimation.passiveidle, state.ageInTicks, 1.0f);
            this.animateWalk(WinterwatcherAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.animate(this.entity.animationState2, WinterwatcherAnimation.aggro, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState3, WinterwatcherAnimation.castlight, state.ageInTicks, 1.0f);
            this.animate(this.entity.animationState4, WinterwatcherAnimation.castheavy, state.ageInTicks, 1.25f);
            super.setupAnim(state);
        }
    }
}

