/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.mcreator.deepborn.procedures.GunpowderBlockExplodeProcedure;
import net.mcreator.deepborn.procedures.GunpowderBlockNeighbourBlockChangesProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.redstone.Orientation;

public class GunpowderBlockBlock
extends FallingBlock {
    public static final MapCodec<GunpowderBlockBlock> CODEC = GunpowderBlockBlock.simpleCodec(GunpowderBlockBlock::new);

    public MapCodec<GunpowderBlockBlock> codec() {
        return CODEC;
    }

    public GunpowderBlockBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SAND).strength(0.25f, 0.01f).ignitedByLava().instrument(NoteBlockInstrument.SNARE));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        GunpowderBlockNeighbourBlockChangesProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void wasExploded(ServerLevel world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        GunpowderBlockExplodeProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

