/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.block;

import net.mcreator.deepborn.procedures.CheckAirProcedure;
import net.mcreator.deepborn.procedures.VerdantMossSpreadProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;

public class VerdantMossBlockBlock
extends Block
implements BonemealableBlock {
    public VerdantMossBlockBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.MOSS).strength(0.15f, 0.2f));
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction direction, BlockState plant) {
        return TriState.TRUE;
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockstate) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            return CheckAirProcedure.execute(world, pos.getX(), pos.getY(), pos.getZ());
        }
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState blockstate) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState blockstate) {
        VerdantMossSpreadProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

