/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.entity;

import javax.annotation.Nullable;
import net.mcreator.deepborn.init.DeepbornModEntities;
import net.mcreator.deepborn.procedures.DwellerBoundingBoxScaleProcedure;
import net.mcreator.deepborn.procedures.DwellerExtralootProcedure;
import net.mcreator.deepborn.procedures.DwellerIsbabyProcedure;
import net.mcreator.deepborn.procedures.DwellerRandomDripProcedure;
import net.mcreator.deepborn.procedures.DwellerSpawningProcedure;
import net.mcreator.deepborn.procedures.DwellerSunexposureProcedure;
import net.mcreator.deepborn.procedures.OreGolemAggroProcedure;
import net.mcreator.deepborn.procedures.RidingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class DwellerEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_Mossy = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Clay = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> DATA_Headwear = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> DATA_Outfit = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_GoldLeftEye = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_GoldRightEye = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_RareEyes = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_IsBaby = SynchedEntityData.defineId(DwellerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();

    public DwellerEntity(EntityType<DwellerEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Mossy, (Object)false);
        builder.define(DATA_Clay, (Object)false);
        builder.define(DATA_Headwear, (Object)"");
        builder.define(DATA_Outfit, (Object)"");
        builder.define(DATA_GoldLeftEye, (Object)false);
        builder.define(DATA_GoldRightEye, (Object)false);
        builder.define(DATA_RareEyes, (Object)0);
        builder.define(DATA_IsBaby, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.1, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, PathfinderMob.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false, false));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:dweller_idle"));
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.zombie.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:dweller_hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"deepborn:dweller_death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        DwellerExtralootProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, EntitySpawnReason reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        DwellerRandomDripProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataMossy", ((Boolean)this.entityData.get(DATA_Mossy)).booleanValue());
        compound.putBoolean("DataClay", ((Boolean)this.entityData.get(DATA_Clay)).booleanValue());
        compound.putString("DataHeadwear", (String)this.entityData.get(DATA_Headwear));
        compound.putString("DataOutfit", (String)this.entityData.get(DATA_Outfit));
        compound.putBoolean("DataGoldLeftEye", ((Boolean)this.entityData.get(DATA_GoldLeftEye)).booleanValue());
        compound.putBoolean("DataGoldRightEye", ((Boolean)this.entityData.get(DATA_GoldRightEye)).booleanValue());
        compound.putInt("DataRareEyes", ((Integer)this.entityData.get(DATA_RareEyes)).intValue());
        compound.putBoolean("DataIsBaby", ((Boolean)this.entityData.get(DATA_IsBaby)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataMossy")) {
            this.entityData.set(DATA_Mossy, (Object)compound.getBoolean("DataMossy"));
        }
        if (compound.contains("DataClay")) {
            this.entityData.set(DATA_Clay, (Object)compound.getBoolean("DataClay"));
        }
        if (compound.contains("DataHeadwear")) {
            this.entityData.set(DATA_Headwear, (Object)compound.getString("DataHeadwear"));
        }
        if (compound.contains("DataOutfit")) {
            this.entityData.set(DATA_Outfit, (Object)compound.getString("DataOutfit"));
        }
        if (compound.contains("DataGoldLeftEye")) {
            this.entityData.set(DATA_GoldLeftEye, (Object)compound.getBoolean("DataGoldLeftEye"));
        }
        if (compound.contains("DataGoldRightEye")) {
            this.entityData.set(DATA_GoldRightEye, (Object)compound.getBoolean("DataGoldRightEye"));
        }
        if (compound.contains("DataRareEyes")) {
            this.entityData.set(DATA_RareEyes, (Object)compound.getInt("DataRareEyes"));
        }
        if (compound.contains("DataIsBaby")) {
            this.entityData.set(DATA_IsBaby, (Object)compound.getBoolean("DataIsBaby"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState1.animateWhen(OreGolemAggroProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(DwellerIsbabyProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(RidingProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        DwellerSunexposureProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        DwellerEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)DwellerBoundingBoxScaleProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DeepbornModEntities.DWELLER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return DwellerSpawningProcedure.execute((LevelAccessor)world, y);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.27);
        builder = builder.add(Attributes.MAX_HEALTH, 24.0);
        builder = builder.add(Attributes.ARMOR, 8.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 40.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.2);
        return builder;
    }
}

