/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deepborn.init;

import net.mcreator.deepborn.entity.CryoShotEntity;
import net.mcreator.deepborn.entity.DwellerEntity;
import net.mcreator.deepborn.entity.FleshReaverEntity;
import net.mcreator.deepborn.entity.KarkhorraEntity;
import net.mcreator.deepborn.entity.NumbgnawEntity;
import net.mcreator.deepborn.entity.OreGolemEntity;
import net.mcreator.deepborn.entity.ParasiteLarvaEntity;
import net.mcreator.deepborn.entity.ScorchedEntity;
import net.mcreator.deepborn.entity.ScorpionEntity;
import net.mcreator.deepborn.entity.WinterwatcherEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DeepbornModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"deepborn");
    public static final DeferredHolder<EntityType<?>, EntityType<DwellerEntity>> DWELLER = DeepbornModEntities.register("dweller", EntityType.Builder.of(DwellerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<ParasiteLarvaEntity>> FLESHREAVER_LARVA = DeepbornModEntities.register("fleshreaver_larva", EntityType.Builder.of(ParasiteLarvaEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<FleshReaverEntity>> FLESH_REAVER = DeepbornModEntities.register("flesh_reaver", EntityType.Builder.of(FleshReaverEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<OreGolemEntity>> ORE_GOLEM = DeepbornModEntities.register("ore_golem", EntityType.Builder.of(OreGolemEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(3).sized(1.3f, 2.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<KarkhorraEntity>> KARKHORRA = DeepbornModEntities.register("karkhorra", EntityType.Builder.of(KarkhorraEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(160).setUpdateInterval(3).fireImmune().sized(8.0f, 6.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<NumbgnawEntity>> NUMBGNAW = DeepbornModEntities.register("numbgnaw", EntityType.Builder.of(NumbgnawEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<WinterwatcherEntity>> WINTERWATCHER = DeepbornModEntities.register("winterwatcher", EntityType.Builder.of(WinterwatcherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CryoShotEntity>> CRYO_SHOT = DeepbornModEntities.register("cryo_shot", EntityType.Builder.of(CryoShotEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.7f, 0.7f));
    public static final DeferredHolder<EntityType<?>, EntityType<ScorpionEntity>> SCORPION = DeepbornModEntities.register("scorpion", EntityType.Builder.of(ScorpionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<ScorchedEntity>> SCORCHED = DeepbornModEntities.register("scorched", EntityType.Builder.of(ScorchedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"deepborn", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DwellerEntity.init(event);
        ParasiteLarvaEntity.init(event);
        FleshReaverEntity.init(event);
        OreGolemEntity.init(event);
        KarkhorraEntity.init(event);
        NumbgnawEntity.init(event);
        WinterwatcherEntity.init(event);
        ScorpionEntity.init(event);
        ScorchedEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DWELLER.get(), DwellerEntity.createAttributes().build());
        event.put((EntityType)FLESHREAVER_LARVA.get(), ParasiteLarvaEntity.createAttributes().build());
        event.put((EntityType)FLESH_REAVER.get(), FleshReaverEntity.createAttributes().build());
        event.put((EntityType)ORE_GOLEM.get(), OreGolemEntity.createAttributes().build());
        event.put((EntityType)KARKHORRA.get(), KarkhorraEntity.createAttributes().build());
        event.put((EntityType)NUMBGNAW.get(), NumbgnawEntity.createAttributes().build());
        event.put((EntityType)WINTERWATCHER.get(), WinterwatcherEntity.createAttributes().build());
        event.put((EntityType)SCORPION.get(), ScorpionEntity.createAttributes().build());
        event.put((EntityType)SCORCHED.get(), ScorchedEntity.createAttributes().build());
    }
}

